/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.ProcessingDecorator;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaggedStringEvaluator
implements IStringEvaluator {
    private static final Logger Log = LoggerFactory.getLogger(TaggedStringEvaluator.class);
    private boolean escape;
    private final IStringEvaluator evaluator;
    private final IDirectTagHandler handler = new IDirectTagHandler(){

        @Override
        public Object endTag(String tagContent, Object context) throws IOException {
            return TaggedStringEvaluator.this.evaluateExpression(tagContent, (IArgs)context);
        }

        @Override
        public void setLocationProvider(ILocationProvider location) {
        }

        @Override
        public void startTag() {
        }
    };
    private boolean strict = true;

    public static TaggedStringEvaluator decorate(IStringEvaluator ... resolvers) {
        IStringEvaluator temp = resolvers.length > 1 ? ScopedResolver.create(resolvers) : resolvers[0];
        ProcessingDecorator decorator = new ProcessingDecorator(temp);
        TaggedStringEvaluator result = new TaggedStringEvaluator(decorator, false);
        decorator.setRecursionEvaluator(result);
        return result;
    }

    public static TaggedStringEvaluator decorateLenient(IStringEvaluator ... resolvers) {
        TaggedStringEvaluator result = TaggedStringEvaluator.decorate(resolvers);
        result.setStrict(false);
        return result;
    }

    protected TaggedStringEvaluator(IStringEvaluator resolver) {
        this(resolver, false);
    }

    public TaggedStringEvaluator(IStringEvaluator resolver, boolean escape) {
        this.evaluator = resolver;
        this.escape = escape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (expression.indexOf(36) < 0) {
            return expression;
        }
        StringReader base = new StringReader(expression);
        DirectTagReader reader = new DirectTagReader(base, this.handler, args, this.isEscape());
        try {
            reader.setForceToString(false);
            int length = expression.length() * 2;
            StringBuilder sb = new StringBuilder(length);
            char[] c = new char[length];
            int i = reader.read(c);
            while (i != -1) {
                sb.append(c, 0, i);
                i = reader.read(c);
            }
            if (sb.length() == 0 && reader.hasResolvedObject()) {
                Object object = reader.getResolvedObject();
                return object;
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            if (this.isStrict()) {
                throw new EvaluationException(e);
            }
            Log.warn("error evaluating {}, '{}'", (Object)expression, (Object)ExceptionTools.getMessage(e));
            String string = expression;
            return string;
        }
        finally {
            StreamTools.close(reader);
        }
    }

    protected Object evaluateExpression(String expression, IArgs args) throws IOException {
        try {
            return this.evaluator.evaluate(expression, args);
        }
        catch (EvaluationException e) {
            if (this.isStrict()) {
                throw new IOException("<error evaluating '" + expression + "' (" + e.getMessage() + ")>", e);
            }
            return "${" + expression + "}";
        }
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

