/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MessageBundleStringResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import java.util.HashMap;
import java.util.Map;

public class NLSStringResolver
extends ContainerResolver {
    private final ClassLoader classLoader;
    private Map<String, IStringEvaluator> resolvers = new HashMap<String, IStringEvaluator>();

    public NLSStringResolver() {
        this(NLSStringResolver.class.getClassLoader());
    }

    public NLSStringResolver(ClassLoader classLoader) {
        super('#');
        this.classLoader = classLoader;
    }

    @Override
    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
        IStringEvaluator evaluator = this.resolvers.get(expression);
        if (evaluator == null) {
            IMessageBundle bundle = MessageTools.getMessageBundle(expression, this.getClassLoader());
            evaluator = new MessageBundleStringResolver(bundle);
            this.resolvers.put(expression, evaluator);
        }
        return evaluator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

