/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.LazyExpressionEvaluator;
import de.intarsys.tools.expression.Mode;
import jakarta.annotation.PostConstruct;
import java.util.EnumMap;
import java.util.Map;

@Singleton
public final class ExpressionEvaluator {
    private static final Map<Mode, IStringEvaluator> EVALUATORS = new EnumMap<Mode, IStringEvaluator>(Mode.class);

    @Deprecated(since="4.23.0", forRemoval=true)
    public static IStringEvaluator get() {
        return ExpressionEvaluator.get(Mode.UNTRUSTED);
    }

    public static IStringEvaluator get(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        return EVALUATORS.computeIfAbsent(mode, LazyExpressionEvaluator::new);
    }

    @Deprecated(since="4.23.0", forRemoval=true)
    public static void set(IStringEvaluator evaluator) {
        ExpressionEvaluator.set(Mode.UNTRUSTED, evaluator);
    }

    public static void set(Mode mode, IStringEvaluator evaluator) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator must not be null");
        }
        EVALUATORS.put(mode, evaluator);
    }

    private ExpressionEvaluator() {
    }

    public static class Install {
        private Mode mode;
        private IStringEvaluator evaluator;

        public Install(Mode mode, IStringEvaluator evaluator) {
            this.mode = mode;
            this.evaluator = evaluator;
        }

        @PostConstruct
        public void install() {
            ExpressionEvaluator.set(this.mode, this.evaluator);
        }
    }
}

