/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.stream.StreamTools;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class StaticCryptdec
implements ICryptdec {
    private final String id;
    private final Cipher ecipher;
    private final Cipher dcipher;
    private byte[] inBuffer;

    public StaticCryptdec(String id, Cipher eCipher, Cipher dCipher) {
        this.id = id;
        this.ecipher = eCipher;
        this.dcipher = dCipher;
    }

    @Override
    public byte[] decrypt(byte[] bytes) throws GeneralSecurityException {
        try {
            return this.dcipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public void decryptFinal(OutputStream os) throws GeneralSecurityException {
        try {
            byte[] outBuffer = this.dcipher.doFinal();
            if (outBuffer != null) {
                os.write(outBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public void decryptUpdate(InputStream is, OutputStream os) throws GeneralSecurityException {
        try {
            byte[] outBuffer;
            this.ensureInBuffer(is);
            int i = is.read(this.inBuffer);
            while (i != -1) {
                outBuffer = this.dcipher.update(this.inBuffer, 0, i);
                if (outBuffer != null) {
                    os.write(outBuffer);
                }
                i = is.read(this.inBuffer);
            }
            outBuffer = this.dcipher.doFinal();
            if (outBuffer != null) {
                os.write(outBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) throws GeneralSecurityException {
        try {
            return this.ecipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public void encryptFinal(OutputStream os) throws GeneralSecurityException {
        try {
            byte[] outBuffer = this.ecipher.doFinal();
            if (outBuffer != null) {
                os.write(outBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public void encryptUpdate(InputStream is, OutputStream os) throws GeneralSecurityException {
        try {
            byte[] outBuffer;
            this.ensureInBuffer(is);
            int i = is.read(this.inBuffer);
            while (i != -1) {
                outBuffer = this.ecipher.update(this.inBuffer, 0, i);
                if (outBuffer != null) {
                    os.write(outBuffer);
                }
                i = is.read(this.inBuffer);
            }
            outBuffer = this.ecipher.doFinal();
            if (outBuffer != null) {
                os.write(outBuffer);
            }
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    protected void ensureInBuffer(InputStream is) {
        if (this.inBuffer == null) {
            this.inBuffer = new byte[StreamTools.suggestBufferSize(is)];
        }
    }

    protected Cipher getDcipher() {
        return this.dcipher;
    }

    protected Cipher getEcipher() {
        return this.ecipher;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

