/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IBaseFunctor;
import de.intarsys.tools.lang.LangTools;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class ArrayTools {
    public static Object[] applyDeep(Object[] array, Function<IArgs.IBinding, Object> function) {
        int i = 0;
        for (Object value : array) {
            LangTools.applyDeep(value, function, new ArrayBinding(array, i++));
        }
        return array;
    }

    public static <A, B> B[] collect(A[] array, IBaseFunctor<B> converter, Class<B> clazz) {
        ArrayList<B> result = new ArrayList<B>(array.length);
        for (A a : array) {
            try {
                result.add(converter.perform(a));
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static Object[] copyDeep(Object[] array) {
        if (array == null) {
            return null;
        }
        Object[] result = new Object[array.length];
        int i = 0;
        for (Object value : array) {
            result[i++] = LangTools.copyDeep(value);
        }
        return result;
    }

    public static <A> A[] createFromList(Class<A> objectClass, List<A> list) {
        Object[] array = (Object[])Array.newInstance(objectClass, list.size());
        int index = 0;
        for (A element : list) {
            Array.set(array, index, element);
            ++index;
        }
        return array;
    }

    public static <A> A detect(A[] list, IBaseFunctor<Boolean> selector) {
        for (A a : list) {
            try {
                if (!Boolean.TRUE.equals(selector.perform(a))) continue;
                return a;
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public static <T> T first(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return null;
        }
        return array[0];
    }

    public static <T> T last(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return null;
        }
        return array[array.length - 1];
    }

    public static <A> A[] reject(A[] array, IBaseFunctor<Boolean> selector, Class<A> clazz) {
        ArrayList<A> result = new ArrayList<A>();
        for (A a : array) {
            try {
                if (Boolean.TRUE.equals(selector.perform(a))) continue;
                result.add(a);
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static void reverse(byte[] array) {
        ArrayTools.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array, int index, int length) {
        for (int i = 0; i < length / 2; ++i) {
            byte temp = array[index + i];
            array[index + i] = array[index + length - i - 1];
            array[index + length - i - 1] = temp;
        }
    }

    public static <T> void reverse(T[] array) {
        ArrayTools.reverse(array, 0, array.length);
    }

    public static <T> void reverse(T[] array, int index, int length) {
        for (int i = 0; i < length / 2; ++i) {
            T temp = array[index + i];
            array[index + i] = array[index + length - i - 1];
            array[index + length - i - 1] = temp;
        }
    }

    public static <A> A[] select(A[] array, IBaseFunctor<Boolean> selector, Class<A> clazz) {
        ArrayList<A> result = new ArrayList<A>();
        for (A a : array) {
            try {
                if (!Boolean.TRUE.equals(selector.perform(a))) continue;
                result.add(a);
            }
            catch (FunctorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result.toArray((Object[])Array.newInstance(clazz, result.size()));
    }

    public static <T> T[] toArray(Class<T> clazz, Collection collection) {
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(array);
    }

    private ArrayTools() {
    }

    public static class ArrayBinding
    implements IArgs.IBinding {
        private final Object[] array;
        private final int index;

        public ArrayBinding(Object[] array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public String getName() {
            return "" + this.index;
        }

        @Override
        public Object getValue() {
            return this.array[this.index];
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(Object value) {
            this.array[this.index] = value;
        }
    }
}

