/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license.mbean;

import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.mbean.CommonMBean;
import de.intarsys.tools.license.mbean.LicenseAccountMBean;
import de.intarsys.tools.license.mbean.LicenseMBean;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseMBeanDeployer
implements IFunctor<Void> {
    private static final Logger Log = LoggerFactory.getLogger(LicenseMBeanDeployer.class);
    public static final String JMX_PROP_ID = "id";
    public static final String JMX_PROP_TYPE = "type";

    protected void deployLicense(License license) throws FunctorExecutionException {
        try {
            LicenseMBean mbean = new LicenseMBean(license);
            String domain = this.mbeanGetDomain();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            this.mbeanDeclareProperties(properties, mbean);
            ObjectName mbeanName = new ObjectName(domain, properties);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.registerMBean(mbean, mbeanName);
        }
        catch (Exception e) {
            Log.warn("license mbean deployment failed", (Throwable)e);
        }
    }

    protected void deployLicenseAccount(ILicenseAccount account) throws FunctorExecutionException {
        try {
            LicenseAccountMBean mbean = new LicenseAccountMBean(account);
            String domain = this.mbeanGetDomain();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            this.mbeanDeclareProperties(properties, mbean);
            ObjectName mbeanName = new ObjectName(domain, properties);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.registerMBean(mbean, mbeanName);
        }
        catch (Exception e) {
            Log.warn("license mbean deployment failed", (Throwable)e);
        }
    }

    protected void mbeanDeclareProperties(Hashtable<String, String> properties, CommonMBean object) {
        properties.put(JMX_PROP_TYPE, object.getType());
        properties.put(JMX_PROP_ID, object.getId());
    }

    protected String mbeanGetDomain() {
        return "de.intarsys";
    }

    public Void perform(IFunctorCall call) throws FunctorException {
        List<License> licenses = LicenseEnvironment.get().getLicenses();
        for (License license : licenses) {
            this.deployLicense(license);
        }
        for (LicenseProduct product : LicenseEnvironment.get().getLicenseProducts()) {
            for (ILicenseAccount account : product.getAccounts()) {
                this.deployLicenseAccount(account);
            }
        }
        return null;
    }
}

