/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.preferences.IPreferences;
import java.time.Instant;
import java.time.ZoneId;

public abstract class LicensePropertyUnitPerTime
extends LicensePropertyUnit {
    private static final Attribute ATTR_LASTACCESS = new Attribute("lastAccess");
    protected static final ZoneId CachedZoneId = ZoneId.systemDefault();

    protected static Instant getLastAccess(IAttributeSupport as) {
        return (Instant)as.getAttribute((Object)ATTR_LASTACCESS);
    }

    protected static void setLastAccess(IAttributeSupport as, Instant value) {
        if (value == null) {
            as.removeAttribute((Object)ATTR_LASTACCESS);
        } else {
            as.setAttribute((Object)ATTR_LASTACCESS, (Object)value);
        }
    }

    @Override
    public float convertFrom(LicensePropertyUnit from, float value) {
        return (float)((double)from.getCanonicalValue(value) * (double)this.getAccountingPeriod());
    }

    @Override
    protected void deposit(LicenseAccount account, int amount) throws LicenseException {
        this.load(account);
        LicensePropertyUnitPerTime.incrementSpentTokens(account, -amount);
        this.save(account);
    }

    protected abstract long getAccountingPeriod();

    @Override
    public float getCanonicalValue(float value) {
        return (float)((double)value / (double)this.getAccountingPeriod());
    }

    protected Instant getNextReset(Instant lastAccess) {
        return lastAccess.plusMillis(this.getAccountingPeriod());
    }

    @Override
    public Instant getNextReset(LicenseAccount account) {
        this.load(account);
        Instant lastAccess = LicensePropertyUnitPerTime.getLastAccess(account);
        if (lastAccess == null) {
            return null;
        }
        return this.getNextReset(lastAccess);
    }

    protected boolean isTimeToReset(LicenseAccount account, long current) {
        Instant nextReset = this.getNextReset(account);
        if (nextReset == null) {
            return true;
        }
        return current >= nextReset.toEpochMilli();
    }

    @Override
    protected void load(LicenseAccount account, IPreferences propertyNode) {
        super.load(account, propertyNode);
        long value = propertyNode.getLong("lastAccess");
        if (value == 0L) {
            LicensePropertyUnitPerTime.setLastAccess(account, null);
        } else {
            LicensePropertyUnitPerTime.setLastAccess(account, Instant.ofEpochMilli(value));
        }
    }

    protected void resetAccount(LicenseAccount account) {
        LicensePropertyUnitPerTime.setSpentTokens(account, 0);
        LicensePropertyUnitPerTime.setLastAccess(account, Instant.ofEpochMilli(System.currentTimeMillis()));
    }

    @Override
    protected void save(LicenseAccount account, IPreferences propertyNode) {
        super.save(account, propertyNode);
        propertyNode.put("lastAccess", LicensePropertyUnitPerTime.getLastAccess(account).toEpochMilli());
    }

    @Override
    protected void withdraw(LicenseAccount account, LicenseProperty property, int amount) throws LicenseException {
        int maxTokens;
        this.load(account);
        long current = System.currentTimeMillis();
        if (this.isTimeToReset(account, current)) {
            this.resetAccount(account);
        }
        if ((maxTokens = this.getLimit(property, account)) >= 0 && LicensePropertyUnitPerTime.getSpentTokens(account) >= maxTokens) {
            this.handleRestrictionExceeded(account, property, maxTokens, LicensePropertyUnitPerTime.getSpentTokens(account));
        }
        LicensePropertyUnitPerTime.incrementSpentTokens(account, amount);
        this.save(account);
    }
}

