/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.cli;

import de.intarsys.tools.crypto.Secret;
import picocli.CommandLine;

public class OptionCertificate {
    private String fileName;
    private Secret password;

    public OptionCertificate(String fileName) {
        this.fileName = fileName;
    }

    public OptionCertificate(String fileName, Secret password) {
        this.fileName = fileName;
        this.password = password;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Secret getPassword() {
        return this.password;
    }

    public static class OptionCertificateConverter
    implements CommandLine.ITypeConverter<OptionCertificate> {
        public OptionCertificate convert(String value) throws Exception {
            String[] tokens = value.split(":", 2);
            String fileName = tokens[0];
            if (tokens.length == 1) {
                return new OptionCertificate(fileName);
            }
            Secret password = Secret.hide((char[])tokens[1].toCharArray());
            return new OptionCertificate(fileName, password);
        }
    }
}

