/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate.http;

import java.net.URI;
import java.util.LinkedList;
import java.util.Optional;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

final class SniConfigurator {
    private final String hostName;

    private SniConfigurator(String hostName) {
        this.hostName = hostName;
    }

    String getHostName() {
        return this.hostName;
    }

    static Optional<SniConfigurator> createWhenHostHeader(URI hostUri, String sniHostName, boolean whenDiffer) {
        if (sniHostName == null) {
            return Optional.empty();
        }
        if (hostUri != null) {
            String hostUriString = hostUri.getHost();
            if (!whenDiffer && hostUriString.equals(sniHostName)) {
                return Optional.empty();
            }
        }
        return Optional.of(new SniConfigurator(sniHostName));
    }

    void setServerNames(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        this.updateSSLParameters(sslParameters);
        sslEngine.setSSLParameters(sslParameters);
    }

    void setServerNames(SSLSocket sslSocket) {
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        this.updateSSLParameters(sslParameters);
        sslSocket.setSSLParameters(sslParameters);
    }

    SSLParameters updateSSLParameters(SSLParameters sslParameters) {
        SNIHostName serverName = new SNIHostName(this.hostName);
        LinkedList<SNIServerName> serverNames = new LinkedList<SNIServerName>();
        serverNames.add(serverName);
        sslParameters.setServerNames(serverNames);
        return sslParameters;
    }
}

