/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementProxy;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.tag.ITagSupport;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentTypeProxy
extends ElementProxy
implements IDocumentType,
IPresentationSupport,
ITagSupport {
    private final Map listeners = new HashMap();

    @Override
    public void addExtension(String extension) {
        this.myDelegate().addExtension(extension);
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.basicGetRealized() == null) {
            this.listeners.put(type, listener);
            return;
        }
        this.myDelegate().addNotificationListener(type, listener);
    }

    public IDocument createFromImpl(ILocator locator, Object impl) throws IOException {
        return this.myDelegate().createFromImpl(locator, impl);
    }

    public IDocument createFromLocator(ILocator locator, IArgs args) throws IOException {
        return this.myDelegate().createFromLocator(locator, args);
    }

    public IDocument createFromLocator(Object oLocator, IArgs args) throws IOException {
        ILocator locator = DocumentTools.createLocator(oLocator);
        return this.myDelegate().createFromLocator(locator, args);
    }

    public IDocument createNew(IArgs args) throws IOException {
        return this.myDelegate().createNew(args);
    }

    @Override
    public String getDefaultExtension() {
        return this.myDelegate().getDefaultExtension();
    }

    @Override
    public String getDefaultMimeType() {
        return this.myDelegate().getDefaultMimeType();
    }

    public String getDescription() {
        if (this.myDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.myDelegate()).getDescription();
        }
        return this.getLabel();
    }

    public IDocument[] getDocuments() {
        return this.myDelegate().getDocuments();
    }

    public String getIconName() {
        if (this.myDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.myDelegate()).getIconName();
        }
        return null;
    }

    @Override
    public String getId() {
        String id = this.getElement().attributeValue("id", null);
        if (id == null) {
            id = this.getElement().attributeValue(this.getProxyClassAttribute(), null);
        }
        return id;
    }

    public String getLabel() {
        if (this.myDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.myDelegate()).getLabel();
        }
        return this.myDelegate().getClass().getName();
    }

    public List<Tag> getTags() {
        return TagTools.getTagList((Object)this.myDelegate());
    }

    public String getTip() {
        if (this.myDelegate() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.myDelegate()).getTip();
        }
        return this.getDescription();
    }

    public Object invoke(String name, IArgs args) throws MethodException {
        return this.myDelegate().invoke(name, args);
    }

    @Override
    public boolean isIntegrate() {
        return this.myDelegate().isIntegrate();
    }

    public IDocument lookupDocument(ILocator locator) {
        return this.myDelegate().lookupDocument(locator);
    }

    protected IDocumentType myDelegate() {
        return (IDocumentType)this.getRealized();
    }

    protected Object realize() throws ObjectCreationException {
        IDocumentType type = (IDocumentType)super.realize();
        for (Map.Entry entry : this.listeners.entrySet()) {
            EventType eventType = (EventType)entry.getKey();
            INotificationListener listener = (INotificationListener)entry.getValue();
            type.addNotificationListener(eventType, listener);
        }
        return type;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.basicGetRealized() == null) {
            this.listeners.remove(type);
            return;
        }
        this.myDelegate().removeNotificationListener(type, listener);
    }

    @Override
    public void setDefaultExtension(String defaultExtension) {
        this.myDelegate().setDefaultExtension(defaultExtension);
    }

    @Override
    public void setDefaultMimeType(String defaultMimetype) {
        this.myDelegate().setDefaultMimeType(defaultMimetype);
    }
}

