/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Extensions;
import de.intarsys.asn1.x509.Name;
import de.intarsys.asn1.x509.Validity;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;

public class TBSCertificate
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        ASN1ValueHolder algo = this.isVersionObjectExistent() ? this.getValueHolder().getChild(2) : this.getValueHolder().getChild(1);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(algo);
    }

    public Extensions getExtensions() {
        ASN1ValueHolder ext = this.getValueHolder().getNextTaggedGetChild(5, 3, true);
        return (Extensions)Extensions.FACTORY.create(ext);
    }

    public Name getIssuer() {
        ASN1ValueHolder issuer = this.isVersionObjectExistent() ? this.getValueHolder().getChild(3) : this.getValueHolder().getChild(2);
        return (Name)Name.FACTORY.create(issuer);
    }

    public DERBitString getIssuerUniqueId() {
        return this.getValueHolder().getNextTaggedGetChild(5, 1, false).toDERBitString();
    }

    public CertificateSerialNumber getSerialNumber() {
        ASN1ValueHolder serialNumber = this.isVersionObjectExistent() ? this.getValueHolder().getChild(1) : this.getValueHolder().getChild(0);
        return (CertificateSerialNumber)CertificateSerialNumber.FACTORY.create(serialNumber);
    }

    public Name getSubject() {
        ASN1ValueHolder subject = this.isVersionObjectExistent() ? this.getValueHolder().getChild(5) : this.getValueHolder().getChild(4);
        return (Name)Name.FACTORY.create(subject);
    }

    public byte[] getSubjectPublicKeyInfo() throws IOException {
        ASN1ValueHolder value = this.isVersionObjectExistent() ? this.getValueHolder().getChild(6) : this.getValueHolder().getChild(5);
        return ASN1Tools.toByteArray(value);
    }

    public DERBitString getSubjectUniqueId() {
        return this.getValueHolder().getNextTaggedGetChild(5, 2, false).toDERBitString();
    }

    public Validity getValidity() {
        ASN1ValueHolder validity = this.isVersionObjectExistent() ? this.getValueHolder().getChild(4) : this.getValueHolder().getChild(3);
        return (Validity)Validity.FACTORY.create(validity);
    }

    public Version getVersion() {
        Version v = (Version)Version.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(0, 0, true));
        if (v == null) {
            v = Version.create(0);
        }
        return v;
    }

    private boolean isVersionObjectExistent() {
        ASN1TaggedHolder o = this.getValueHolder().getNextTagged(0, 0);
        return o != null;
    }

    public void setAlgorithmIdentifier(AlgorithmIdentifier algoId) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(2, algoId);
        } else {
            this.getValueHolder().setChild(1, algoId);
        }
    }

    public void setExtensions(Extensions extensions) {
        int index = 7;
        if (this.getValueHolder().getNextTagged(index, 1) != null) {
            ++index;
        }
        if (this.getValueHolder().getNextTagged(index, 2) != null) {
            ++index;
        }
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 3, extensions);
        this.getValueHolder().setChild(index, tagged);
    }

    public void setIssuer(Name issuer) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(3, issuer);
        } else {
            this.getValueHolder().setChild(2, issuer);
        }
    }

    public void setSerialNumber(CertificateSerialNumber serialNumber) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(1, serialNumber);
        } else {
            this.getValueHolder().setChild(0, serialNumber);
        }
    }

    public void setSubject(Name subject) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(5, subject);
        } else {
            this.getValueHolder().setChild(4, subject);
        }
    }

    public void setSubjectPublicKeyInfo(byte[] value) throws IOException {
        ASN1Primitive wrapped = ASN1Tools.create(value);
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(6, (ASN1Encodable)wrapped);
        } else {
            this.getValueHolder().setChild(5, (ASN1Encodable)wrapped);
        }
    }

    public void setValidity(Validity validity) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(4, validity);
        } else {
            this.getValueHolder().setChild(3, validity);
        }
    }

    public void setVersion(Version version) {
        if (this.isVersionObjectExistent()) {
            ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, version);
            this.getValueHolder().setChild(0, tagged);
        } else {
            ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, version);
            this.getValueHolder().insertChild(0, tagged);
        }
    }

    public static class Factory
    extends ASN1Based.Factory<TBSCertificate> {
    }
}

