/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jempbox.xmp.IElementable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static byte[] asByteArray(Document document, String encoding) throws TransformerException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        XMLUtil.write(document, bytes, encoding);
        return bytes.toByteArray();
    }

    public static List<Element> getBagListItems(Element schema, String bagName) {
        Element contributor;
        NodeList bagList;
        List<Element> retval = new ArrayList<Element>();
        NodeList nodes = schema.getElementsByTagName(bagName);
        if (nodes.getLength() > 0 && (bagList = (contributor = (Element)nodes.item(0)).getElementsByTagName("rdf:Bag")).getLength() > 0) {
            Element bag = (Element)bagList.item(0);
            retval = new ArrayList();
            NodeList items = bag.getChildNodes();
            for (int i = 0; i < items.getLength(); ++i) {
                Node li = items.item(i);
                if (!(li instanceof Element) || !((Element)li).getNodeName().equals("rdf:li")) continue;
                retval.add((Element)li);
            }
            retval = Collections.unmodifiableList(retval);
        }
        return retval;
    }

    public static Element getElement(Element parent, String elementName) {
        Element retval = null;
        NodeList children = parent.getElementsByTagName(elementName);
        if (children.getLength() > 0) {
            retval = (Element)children.item(0);
        }
        return retval;
    }

    public static Integer getIntValue(Element parent, String nodeName) {
        String stringValue = XMLUtil.getStringValue(XMLUtil.getElement(parent, nodeName));
        return stringValue == null ? null : Integer.valueOf(stringValue);
    }

    public static List<Element> getSeqListItems(Element schema, String seqName) {
        Element contributor;
        NodeList bagList;
        List<Element> retval = new ArrayList<Element>();
        NodeList nodes = schema.getElementsByTagName(seqName);
        if (nodes.getLength() > 0 && (bagList = (contributor = (Element)nodes.item(0)).getElementsByTagName("rdf:Seq")).getLength() > 0) {
            Element bag = (Element)bagList.item(0);
            retval = new ArrayList();
            NodeList items = bag.getChildNodes();
            for (int i = 0; i < items.getLength(); ++i) {
                Element element;
                Node node = items.item(i);
                if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals("rdf:li")) continue;
                retval.add(element);
            }
            retval = Collections.unmodifiableList(retval);
        }
        return retval;
    }

    public static String getStringValue(Element node) {
        if (node == null) {
            return "";
        }
        String retval = "";
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node next = children.item(i);
            if (!(next instanceof Text)) continue;
            retval = next.getNodeValue();
        }
        return retval;
    }

    public static String getStringValue(Element parent, String nodeName) {
        return XMLUtil.getStringValue(XMLUtil.getElement(parent, nodeName));
    }

    public static Document newDocument() throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static Document parse(InputSource is) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            XMLUtil.removeIgnorableWhitespace(document);
            return document;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static void removeIgnorableWhitespace(Node node) {
        Node child;
        int i;
        boolean containsElement = false;
        NodeList children = node.getChildNodes();
        for (i = children.getLength() - 1; i >= 0; --i) {
            child = children.item(i);
            if (child.getNodeType() != 1) continue;
            containsElement = true;
            XMLUtil.removeIgnorableWhitespace(child);
        }
        if (containsElement) {
            for (i = children.getLength() - 1; i >= 0; --i) {
                String value;
                child = children.item(i);
                if (child.getNodeType() != 3 || (value = child.getNodeValue()) != null && !value.isBlank()) continue;
                node.removeChild(child);
            }
        }
    }

    public static Document parse(InputStream is) throws IOException {
        return XMLUtil.parse(new InputSource(is));
    }

    public static void setElementableValue(Element parent, String name, IElementable node) {
        NodeList nodes = parent.getElementsByTagName(name);
        if (node == null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                parent.removeChild(nodes.item(i));
            }
        } else if (nodes.getLength() == 0) {
            if (parent.hasChildNodes()) {
                Node firstChild = parent.getChildNodes().item(0);
                parent.insertBefore(node.getElement(), firstChild);
            } else {
                parent.appendChild(node.getElement());
            }
        } else {
            Node oldNode = nodes.item(0);
            parent.replaceChild(node.getElement(), oldNode);
        }
    }

    public static void setIntValue(Element parent, String nodeName, Integer intValue) {
        Element currentValue = XMLUtil.getElement(parent, nodeName);
        if (intValue == null) {
            if (currentValue != null) {
                parent.removeChild(currentValue);
            }
        } else {
            if (currentValue == null) {
                currentValue = parent.getOwnerDocument().createElement(nodeName);
                parent.appendChild(currentValue);
            }
            XMLUtil.setStringValue(currentValue, intValue.toString());
        }
    }

    public static void setStringValue(Element node, String value) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node next = children.item(i);
            if (!(next instanceof Text)) continue;
            node.removeChild(next);
        }
        node.appendChild(node.getOwnerDocument().createTextNode(value));
    }

    public static void setStringValue(Element parent, String nodeName, String nodeValue) {
        Element currentValue = XMLUtil.getElement(parent, nodeName);
        if (nodeValue == null) {
            if (currentValue != null) {
                parent.removeChild(currentValue);
            }
        } else {
            if (currentValue == null) {
                currentValue = parent.getOwnerDocument().createElement(nodeName);
                parent.appendChild(currentValue);
            }
            XMLUtil.setStringValue(currentValue, nodeValue);
        }
    }

    public static void write(Document document, OutputStream output, String encoding) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        transformer.transform(new DOMSource(document), new StreamResult(output));
    }

    private XMLUtil() {
    }
}

