/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.CommonFieldDefinitionStrategy;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TagResolver;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.GeometryTools;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagList;
import de.intarsys.tools.tag.TagTools;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsFieldDefinitionStrategy
extends CommonFieldDefinitionStrategy {
    private static final Logger Log = LoggerFactory.getLogger(TagsFieldDefinitionStrategy.class);
    private String tagPrefix = "annot";

    protected IArgs createAnnotationArgs(Tag tag) {
        IArgs annotationArgs = null;
        try {
            annotationArgs = ArgTools.toArgs((Object)tag.getValue());
            Log.trace("tag {} parsed args {}", (Object)tag.getKey(), (Object)annotationArgs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse '" + tag.getValue() + "'", e);
        }
        if (annotationArgs == null) {
            annotationArgs = Args.create();
        }
        return annotationArgs;
    }

    protected void createAnnotationDefinitionFromTags(PDDocument doc, IFieldDefinition fieldDefinition, List<AnnotationDefinition> annotationDefinitions) {
        String fieldName = fieldDefinition.createFieldName();
        TagList tags = this.createTagList(doc);
        if (tags != null) {
            for (Tag tag : tags.getTags()) {
                String defaultName;
                Args template;
                IArgs annotationArgs;
                String name;
                if (tag.getKey() == null || !tag.getKey().startsWith(this.getTagPrefix() + ".") || !LangTools.equals((Object)fieldName, (Object)(name = this.getProperty(tag, annotationArgs = this.createAnnotationArgs(tag), (IArgs)(template = Args.create()), "name", defaultName = this.createAnnotationNameDefault(tag))))) continue;
                this.fillAnnotationArgs(annotationArgs, tag, (IArgs)template, name);
                AnnotationDefinition annotDef = this.createAnnotationDefinition(fieldDefinition, annotationArgs);
                annotationDefinitions.add(annotDef);
            }
        }
    }

    protected String createAnnotationNameDefault(Tag tag) {
        int tagPrefixLength = this.getTagPrefix().length() + 1;
        if (tag.getKey().length() > tagPrefixLength) {
            return tag.getKey().substring(tagPrefixLength);
        }
        return null;
    }

    @Override
    public PDAcroFormField createField(PDDocument doc, IFieldDefinition fieldDefinition) {
        if (doc == null) {
            return null;
        }
        ArrayList<AnnotationDefinition> annotationDefinitions = new ArrayList<AnnotationDefinition>();
        this.createAnnotationDefinitionFromTags(doc, fieldDefinition, annotationDefinitions);
        if (annotationDefinitions.isEmpty()) {
            return null;
        }
        this.createAnnotationDefinitionsFromEndorsement(fieldDefinition, annotationDefinitions);
        return this.createField(doc, fieldDefinition, annotationDefinitions);
    }

    protected TagList createTagList(PDDocument doc) {
        List tags = TagTools.getTagList((Object)doc);
        if (!tags.isEmpty()) {
            return new TagList(tags);
        }
        try {
            Object target;
            Object resolver = ExpressionEvaluator.get((Mode)Mode.UNTRUSTED).evaluate("tags", (IArgs)Args.create());
            if (resolver instanceof TagResolver && (target = ((TagResolver)resolver).getObject()) instanceof TagList) {
                return (TagList)target;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void fillAnnotationArgs(IArgs annotationArgs, Tag tag, IArgs template, String name) {
        annotationArgs.put("name", (Object)name);
        String position = this.getProperty(tag, annotationArgs, template, "position", null);
        String size = this.getProperty(tag, annotationArgs, template, "size", null);
        String page = this.getProperty(tag, annotationArgs, template, "page", "0");
        String pageRange = ArgTools.getString((IArgs)annotationArgs, (String)"pageRange", (String)page);
        Point2D positionPoint = new Point2D.Float(0.0f, 0.0f);
        if (!StringTools.isEmpty((String)position)) {
            positionPoint = GeometryTools.parsePoint((String)position);
        } else {
            String llx = this.getProperty(tag, annotationArgs, template, "llx", "0");
            String lly = this.getProperty(tag, annotationArgs, template, "lly", "0");
            positionPoint.setLocation(Float.parseFloat(llx), Float.parseFloat(lly));
        }
        Point2D sizePoint = new Point2D.Float(0.0f, 0.0f);
        if (!StringTools.isEmpty((String)size)) {
            sizePoint = GeometryTools.parsePoint((String)size);
        } else {
            String width = this.getProperty(tag, annotationArgs, template, "width", "100");
            String height = this.getProperty(tag, annotationArgs, template, "height", "100");
            sizePoint.setLocation(Float.parseFloat(width), Float.parseFloat(height));
        }
        annotationArgs.put("position", (Object)(positionPoint.getX() + "*" + positionPoint.getY()));
        annotationArgs.put("size", (Object)(sizePoint.getX() + "*" + sizePoint.getY()));
        annotationArgs.put("pageRange", (Object)pageRange);
    }

    protected String getProperty(Tag tag, IArgs annotationArgs, IArgs template, String property, String defaultValue) {
        String value = ArgTools.getString((IArgs)annotationArgs, (String)property, null);
        if (StringTools.isEmpty((String)value)) {
            Object tmpValue = TagTools.getTagMeta((Tag)tag, (String)property, null);
            String string = value = tmpValue == null ? null : tmpValue.toString();
        }
        if (StringTools.isEmpty((String)value)) {
            value = ArgTools.getString((IArgs)template, (String)property, (String)defaultValue);
        }
        return value;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }
}

