/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.AnnotationType;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;

public abstract class CommonFieldDefinition
implements IFieldDefinition {
    private final PDDocument document;
    private AnnotationDefinition defaultAnnotationDefinition;
    private String fieldName;
    private PDAcroFormField cachedField;
    private final IArgs fieldArgs;
    private final IArgs contextArgs;
    private final IStringEvaluator expressionEvaluator;
    private final IStringEvaluator templateEvaluator;
    private IAppearanceCreator appearanceCreator;
    private boolean embedFonts = true;
    private String fieldType = IFieldDefinition.FIELDTYPE_SIG;

    protected CommonFieldDefinition(PDDocument doc, IArgs fieldArgs, IArgs contextArgs, IStringEvaluator evaluator) {
        this.document = doc;
        this.fieldArgs = fieldArgs;
        this.contextArgs = contextArgs;
        this.expressionEvaluator = evaluator;
        this.templateEvaluator = TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{evaluator, ExpressionEvaluator.get((Mode)Mode.UNTRUSTED)});
        this.initFromArgs();
    }

    protected abstract PDAcroFormField createField();

    @Override
    public String createFieldName() {
        return this.getDefaultAnnotationDefinition().createFieldName();
    }

    @Override
    public IAppearanceCreator getAppearanceCreator() {
        return this.appearanceCreator;
    }

    @Override
    public IArgs getContextArgs() {
        return this.contextArgs;
    }

    @Override
    public AnnotationDefinition getDefaultAnnotationDefinition() {
        return this.defaultAnnotationDefinition;
    }

    @Override
    public AnnotationType getDefaultAnnotationType(int count) {
        if (this.getDefaultAnnotationDefinition().getAnnotationType() == AnnotationType.auto) {
            return count > 1 ? AnnotationType.markup : AnnotationType.widget;
        }
        if (this.getDefaultAnnotationDefinition().getAnnotationType() == AnnotationType.markup) {
            return AnnotationType.markup;
        }
        return AnnotationType.widget;
    }

    @Override
    public PDDocument getDocument() {
        return this.document;
    }

    public IStringEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    @Override
    public final PDAcroFormField getField() {
        if (this.cachedField == null) {
            this.cachedField = this.createField();
        }
        return this.cachedField;
    }

    @Override
    public IArgs getFieldArgs() {
        return this.fieldArgs;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getFieldType() {
        return this.fieldType;
    }

    @Override
    public IStringEvaluator getTemplateEvaluator() {
        return this.templateEvaluator;
    }

    protected void initFromArgs() {
        this.setDefaultAnnotationDefinition(new AnnotationDefinition(this, this.getFieldArgs()));
        this.setFieldName(ArgTools.getString((IArgs)this.getFieldArgs(), (String)"name", (String)this.getFieldName()));
        this.setFieldName(ArgTools.getString((IArgs)this.getFieldArgs(), (String)"fieldName", (String)this.getFieldName()));
        this.setFieldType(ArgTools.getString((IArgs)this.getFieldArgs(), (String)"fieldType", (String)this.getFieldType()));
        this.setEmbedFonts(ArgTools.getBoolStrict((IArgs)this.getFieldArgs(), (String)"embedFonts", (boolean)this.isEmbedFonts()));
    }

    @Override
    public boolean isEmbedFonts() {
        return this.embedFonts;
    }

    public void setAppearanceCreator(IAppearanceCreator appearanceCreator) {
        this.appearanceCreator = appearanceCreator;
    }

    public void setDefaultAnnotationDefinition(AnnotationDefinition defaultAnnotationDefinition) {
        this.defaultAnnotationDefinition = defaultAnnotationDefinition;
    }

    public void setEmbedFonts(boolean embedFonts) {
        this.embedFonts = embedFonts;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        ArgTools.putPath((IArgs)this.getFieldArgs(), (String)"fieldName", (Object)fieldName);
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
        ArgTools.putPath((IArgs)this.getFieldArgs(), (String)"fieldType", (Object)fieldType);
    }
}

