/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.common;

import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public abstract class CommonAnnotationFactory
implements IAnnotationFactory {
    public static final String ATTR_SHAPE = "shape";
    public static final String ATTR_APPEARANCECREATOR = "appearanceCreator";

    protected abstract PDAnnotation basicCreateAnnotation(PDPage var1, CDSRectangle var2, Map var3) throws ObjectCreationException;

    public PDAnnotation createAnnotation(PDPage page, Rectangle2D rect, Map attributes) throws ObjectCreationException {
        CDSRectangle cdsRect = new CDSRectangle(rect).normalize();
        this.createAnnotationPreProcess(page, cdsRect, attributes);
        PDAnnotation annotation = this.basicCreateAnnotation(page, cdsRect, attributes);
        this.createAnnotationState(page, annotation, cdsRect, attributes);
        this.createAnnotationReference(page, annotation, attributes);
        this.createAnnotationPostProcess(page, annotation, cdsRect, attributes);
        return annotation;
    }

    protected void createAnnotationPostProcess(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) {
        IAppearanceCreator appearanceCreator = (IAppearanceCreator)attributes.get(ATTR_APPEARANCECREATOR);
        if (appearanceCreator == null) {
            AppearanceCreatorTools.createAppearance((PDAnnotation)annotation);
        } else {
            PDAppearance appearance = appearanceCreator.createAppearance(annotation, null);
            annotation.setAppearance(appearance);
        }
    }

    protected void createAnnotationPreProcess(PDPage page, CDSRectangle rect, Map attributes) {
    }

    protected void createAnnotationReference(PDPage page, PDAnnotation annotation, Map attributes) throws ObjectCreationException {
        page.addAnnotation(annotation);
    }

    protected void createAnnotationState(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) throws ObjectCreationException {
        annotation.setRectangle(rect);
    }

    protected PDAnnotation updatePDReference(PDPage page, PDAnnotation annotation) {
        COSObject cosAnnotation = annotation.cosGetObject();
        for (PDAnnotation current : page.getAnnotations()) {
            if (!cosAnnotation.equals(current.cosGetObject())) continue;
            return current;
        }
        return annotation;
    }
}

