/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.asn1.cms.CertificateSet;
import de.intarsys.asn1.cms.OCSPRevocationInfo;
import de.intarsys.asn1.cms.OtherRevocationInfoFormat;
import de.intarsys.asn1.cms.RevocationInfoChoices;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CommonCertificate;
import de.intarsys.asn1.x509.crl.CertificateList;
import de.intarsys.security.app.signature.CommonValidationDataExtender;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.cms.signature.CMSSignatureEntry;
import de.intarsys.security.method.cms.signature.RevocationInfos;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPTools;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ocsp.OCSPResponse;

public class CMSValidationDataExtender
extends CommonValidationDataExtender<CMSSignatureEntry> {
    protected Supplier<CertificateSet> createCertificatesSupplier(final SignedData signedData) {
        return new Supplier(){
            private CertificateSet certificates;

            public Object get() {
                if (this.certificates == null) {
                    this.certificates = signedData.getCertificates();
                    if (this.certificates == null) {
                        this.certificates = (CertificateSet)CertificateSet.FACTORY.createNew();
                        signedData.setCertificates(this.certificates);
                    }
                }
                return this.certificates;
            }
        };
    }

    protected Supplier<RevocationInfoChoices> createRevocationInfosSupplier(final SignedData signedData) {
        return new Supplier(){
            private RevocationInfoChoices revocationInfoChoices;

            public Object get() {
                if (this.revocationInfoChoices == null) {
                    this.revocationInfoChoices = signedData.getCrls();
                    if (this.revocationInfoChoices == null) {
                        this.revocationInfoChoices = (RevocationInfoChoices)RevocationInfoChoices.FACTORY.createNew();
                        signedData.setCrls(this.revocationInfoChoices);
                    }
                }
                return this.revocationInfoChoices;
            }
        };
    }

    protected void extend(CMSSignatureEntry entry, IExtendedValidationData validationData) throws IOException {
        CMSSignature cmsSignature = entry.getCmsSignature();
        SignedData signedData = cmsSignature.getCMS().getSignedData();
        Supplier<RevocationInfoChoices> supplierRIC = this.createRevocationInfosSupplier(signedData);
        Supplier<CertificateSet> supplierCS = this.createCertificatesSupplier(signedData);
        try {
            this.extendRevocationValues(supplierRIC, cmsSignature, validationData);
            this.extendCertificateValues(supplierCS, cmsSignature, validationData);
        }
        catch (Exception e) {
            throw (IOException)ExceptionTools.unwrapTypedFromChain((Throwable)e, IOException.class);
        }
    }

    protected void extendCertificateValues(Supplier<CertificateSet> supplier, CMSSignature cmsSignature, IExtendedValidationData validationData) throws IOException, CertificateException {
        HashSet<IX509PublicKeyCertificate> existingCertificates = new HashSet<IX509PublicKeyCertificate>(Arrays.asList(cmsSignature.getCertificates()));
        validationData.getCertificates().forEach(certificate -> {
            try {
                if (!existingCertificates.contains(certificate)) {
                    Certificate certificateValue = (Certificate)ASN1BasedTools.create((ASN1Based.Factory)Certificate.FACTORY, (byte[])certificate.getEncoded());
                    ((CertificateSet)supplier.get()).add((CommonCertificate)certificateValue);
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
            }
        });
    }

    protected void extendRevocationValues(Supplier<RevocationInfoChoices> supplier, CMSSignature cmsSignature, IExtendedValidationData validationData) throws IOException {
        RevocationInfos revocationInfos = cmsSignature.getRevocationInfos();
        HashSet<IX509CRL> existingCRLs = new HashSet<IX509CRL>(Arrays.asList(revocationInfos.getCRLs()));
        HashSet<IOCSPResponse> existingOCSPs = new HashSet<IOCSPResponse>(Arrays.asList(revocationInfos.getOCSPResponses()));
        validationData.getCRLs().forEach(crl -> {
            try {
                if (!existingCRLs.contains(crl)) {
                    CertificateList certificateList = (CertificateList)ASN1BasedTools.create((ASN1Based.Factory)CertificateList.FACTORY, (byte[])crl.getEncoded());
                    ((RevocationInfoChoices)supplier.get()).add(certificateList);
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
            }
        });
        validationData.getOCSPResponses().forEach(ocsp -> {
            try {
                if (!existingOCSPs.contains(ocsp)) {
                    OCSPResponse ocspResponse = OCSPTools.asAsn1OcspResponse((IOCSPResponse)ocsp);
                    OCSPRevocationInfo ocspRevocationInfo = (OCSPRevocationInfo)OCSPRevocationInfo.FACTORY.createNew();
                    ocspRevocationInfo.setOCSPResponse(ocspResponse);
                    ((RevocationInfoChoices)supplier.get()).add((OtherRevocationInfoFormat)ocspRevocationInfo);
                }
            }
            catch (Exception e) {
                throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
            }
        });
    }
}

