/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.SignedAttributes;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.x509.attr.Attributes;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.ISignatureContainerEntryExtender;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.common.SignatureEntryDefaultStateFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.signature.AttributeMap;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.validation.CMSSignatureEntryValidator;
import de.intarsys.security.method.cms.validation.CMSValidationDataExtender;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.attribute.EmptyAttributeMap;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.security.signature.attribute.ISigningTimeAttribute;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationDataSupport;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSSignatureEntry
implements ISignatureEntry,
IAdapterSupport,
IExtendedValidationDataSupport {
    private static final Logger Log = LoggerFactory.getLogger(CMSSignatureEntry.class);
    private final CMSSignatureContainer signatureContainer;
    private final IAttributeSupport attributeSupport = new de.intarsys.tools.attribute.AttributeMap();
    private final int signerInfoId;

    protected CMSSignatureEntry(CMSSignatureContainer container, int signerInfoId) {
        this.signatureContainer = container;
        this.signerInfoId = signerInfoId;
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureEntryValidator.class) {
            return (T)((Object)new CMSSignatureEntryValidator());
        }
        if (clazz == ISignatureContainerEntryDefaultStateFactory.class) {
            return (T)new SignatureEntryDefaultStateFactory();
        }
        if (clazz == ISignatureContainerEntryExtender.class) {
            return (T)((Object)new CMSValidationDataExtender());
        }
        return null;
    }

    public List<IX509PublicKeyCertificate> getAdditionalCertificates() throws CertificateException, IOException {
        IX509PublicKeyCertificate[] certs = this.getCmsSignature().getCertificates();
        if (certs.length < 2) {
            return Collections.emptyList();
        }
        IX509PublicKeyCertificate signer = this.getCmsSignature().getSignerCertificate(this.signerInfoId);
        ArrayList<IX509PublicKeyCertificate> additional = new ArrayList<IX509PublicKeyCertificate>(certs.length - 1);
        for (IX509PublicKeyCertificate cert : certs) {
            if (cert.equals(signer)) continue;
            additional.add(cert);
        }
        return additional;
    }

    public final Object getAttribute(Object key) {
        return this.attributeSupport.getAttribute(key);
    }

    public CMSSignature getCmsSignature() {
        return this.signatureContainer.getCmsSignature();
    }

    public String getContentType() {
        return this.getCmsSignature().getContentType(this.signerInfoId);
    }

    public Date getCreationDate() {
        return this.getSigningTime();
    }

    public IExtendedValidationData getExtendedValidationData() {
        return this.getCmsSignature().getExtendedValidationData();
    }

    public AlgorithmSpec getHashAlgorithmSpec() {
        return this.getCmsSignature().getHashAlgorithmSpec(this.signerInfoId);
    }

    public Object getImpl() {
        return this.getCmsSignature();
    }

    public String getLocation() {
        return null;
    }

    public String getReason() {
        return null;
    }

    public AlgorithmSpec<SignatureAlgorithm> getSignatureAlgorithmSpec() {
        return this.getCmsSignature().getSignatureAlgorithmSpec(this.signerInfoId);
    }

    public CMSSignatureContainer getSignatureContainer() {
        return this.signatureContainer;
    }

    public byte[] getSignatureEncoded() {
        return this.getCmsSignature().getSignatureBytes(this.signerInfoId);
    }

    public IAttributeMap getSignedAttributes() {
        SignedAttributes signedAttributes = this.getCmsSignature().getSignedAttributes(this.signerInfoId);
        if (signedAttributes != null) {
            return new AttributeMap((Attributes)signedAttributes);
        }
        return EmptyAttributeMap.INSTANCE;
    }

    public IDigest getSignedContentDigest() {
        return this.getCmsSignature().getAttrMessageDigest(this.signerInfoId);
    }

    public ILocator getSignedContentLocator() {
        byte[] content = this.getCmsSignature().getSignedContent();
        if (content == null) {
            return this.getSignatureContainer().getSignedContentLocator();
        }
        return new ByteArrayLocator(content, "signed-content.bytes");
    }

    public IX509PublicKeyCertificate getSignerCertificate() throws CertificateException, IOException {
        return this.getCmsSignature().getSignerCertificate(this.signerInfoId);
    }

    public SignerInfo getSignerInfo() {
        return this.getCmsSignature().getSignerInfo(this.getSignerInfoId());
    }

    public int getSignerInfoId() {
        return this.signerInfoId;
    }

    public Date getSigningTime() {
        try {
            ISigningTimeAttribute signingTime = (ISigningTimeAttribute)this.getSignedAttributes().get("1.2.840.113549.1.9.5");
            if (signingTime != null) {
                return signingTime.getTime();
            }
        }
        catch (IOException e) {
            Log.error("error parsing attribute 'SigningTime':" + e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public byte[] getTimestampInput() {
        return this.getSignatureEncoded();
    }

    public IAttributeMap getUnsignedAttributes() {
        UnsignedAttributes unsignedAttributes = this.getCmsSignature().getUnsignedAttributes(this.signerInfoId);
        if (unsignedAttributes != null) {
            return new AttributeMap((Attributes)unsignedAttributes);
        }
        return EmptyAttributeMap.INSTANCE;
    }

    public final Object removeAttribute(Object key) {
        return this.attributeSupport.removeAttribute(key);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.attributeSupport.setAttribute(key, o);
    }
}

