/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.httpcomponents;

import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;

public class LocatorEntity
extends AbstractHttpEntity {
    private final ILocator locator;

    public LocatorEntity(ILocator locator) {
        this.locator = locator;
        if (locator instanceof IMimeTypeSupport) {
            this.setContentType(((IMimeTypeSupport)locator).getContentType());
        }
    }

    public LocatorEntity(ILocator locator, ContentType contentType) {
        this.locator = locator;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.locator.getInputStream();
    }

    public long getContentLength() {
        try {
            return this.locator.getLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return false;
    }

    public void writeTo(OutputStream os) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream is = null;
        try {
            is = this.locator.getInputStream();
            StreamTools.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }
}

