/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.extension.runtime;

import de.intarsys.tools.bean.IBeanInstallationInstruction;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.objectmodel.FunctorMethod;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.IMethod;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;

public class ObjectMethodInstaller
implements IBeanInstallationInstruction {
    private String implementor;
    private String methodName;
    private String modifiers;
    private IFunctor<?> functor;

    public IFunctor<?> getFunctor() {
        return this.functor;
    }

    public String getImplementor() {
        return this.implementor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    @PostConstruct
    public void install() {
        if (StringTools.isEmpty((String)this.getImplementor())) {
            throw new IllegalArgumentException("'implementor' is required");
        }
        if (StringTools.isEmpty((String)this.getMethodName())) {
            throw new IllegalArgumentException("'methodName' is required");
        }
        if (this.getFunctor() == null) {
            throw new IllegalArgumentException("'functor' is required");
        }
        try {
            IClassSelector selector = ObjectModelTools.createSelector((String)this.getImplementor());
            FunctorMethod method = new FunctorMethod(this.getMethodName(), this.getFunctor());
            method.setModifiers(this.getModifiers());
            method.setDeclaringClass(ObjectModelTools.lookupClass((IClassSelector)selector));
            ObjectModelTools.registerMethod((IClassSelector)selector, (IMethod)method);
        }
        catch (Exception e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void setFunctor(IFunctor<?> functor) {
        this.functor = functor;
    }

    public void setImplementor(String implementor) {
        this.implementor = implementor;
    }

    public void setMethodName(String method) {
        this.methodName = method;
    }

    public void setModifiers(String modifiers) {
        this.modifiers = modifiers;
    }
}

