/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design;

import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.design.AnnotationDesignerException;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.design.AnnotationDesignerAdapter;
import de.intarsys.pdf.design.IDocumentRightSupport;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.geometry.GeometryTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class AbstractAnnotationDesigner
extends AnnotationDesignerAdapter
implements IDocumentRightSupport {
    protected AbstractAnnotationDesigner() {
    }

    @Override
    public PDAnnotation addTransferable(PDAnnotation annotation, PDPage page) throws AnnotationDesignerException {
        PDAnnotation copy = (PDAnnotation)PDAnnotation.META.createFromCos(annotation.cosGetObject().copyDeep());
        Rectangle2D rect = copy.getRectangle().toNormalizedRectangle();
        AffineTransform transform = new AffineTransform();
        Rectangle2D pagerect = page.getCropBox().toNormalizedRectangle();
        PDFGeometryTools.applyUSRtoDS((AffineTransform)transform, (PDPage)page, (Rectangle2D)pagerect, (double)1.0);
        GeometryTools.inverseTransformRect((AffineTransform)transform, (Rectangle2D)rect);
        copy.setRectangle(new CDSRectangle(rect));
        int tmpRotate = page.getNormalizedRotate();
        if (tmpRotate != 0) {
            this.rotateTransferable(copy, tmpRotate);
        }
        page.addAnnotation(copy);
        return copy;
    }

    protected void basicSetBorderColor(PDAnnotation annotation, float[] color) {
    }

    public PDAppearance createAppearance(PDAnnotation annotation) {
        return AppearanceCreatorTools.createAppearance((PDAnnotation)annotation);
    }

    @Override
    public PDAnnotation createTransferable(PDAnnotation annotation) {
        PDAnnotation copy = (PDAnnotation)PDAnnotation.META.createFromCos(annotation.cosGetObject().copyDeep());
        PDPage page = PDAnnotationTools.getPage((PDAnnotation)annotation);
        Rectangle2D rect = copy.getRectangle().toNormalizedRectangle();
        AffineTransform transform = new AffineTransform();
        Rectangle2D pagerect = page.getCropBox().toNormalizedRectangle();
        PDFGeometryTools.applyUSRtoDS((AffineTransform)transform, (PDPage)page, (Rectangle2D)pagerect, (double)1.0);
        GeometryTools.transformRect((AffineTransform)transform, (Rectangle2D)rect);
        copy.setRectangle(new CDSRectangle(rect));
        int tmpRotate = page.getNormalizedRotate();
        if (tmpRotate != 0) {
            this.unrotateTransferable(copy, tmpRotate);
        }
        return copy;
    }

    @Override
    public void deleteAnnotation(PDAnnotation annotation) {
        annotation.dispose();
    }

    @Override
    public float getLineWidth(PDAnnotation annotation) {
        return annotation.getBorderStyleWidth();
    }

    protected void rotateTransferable(PDAnnotation annotation, int rotate) {
    }

    @Override
    public void setBorderColor(PDAnnotation annotation, float[] color) {
        if (!this.supportsBorderColor()) {
            return;
        }
        if (color == null) {
            annotation.setBorderStyleWidth(0.0f);
        }
        this.basicSetBorderColor(annotation, color);
        AppearanceCreatorTools.createAppearance((PDAnnotation)annotation);
    }

    @Override
    public void setLineWidth(PDAnnotation annotation, float width) {
        annotation.setBorderStyleWidth(width);
        AppearanceCreatorTools.createAppearance((PDAnnotation)annotation);
    }

    @Override
    public void setRect(PDAnnotation annotation, CDSRectangle rect) {
        annotation.setRectangle(rect);
        AppearanceCreatorTools.createAppearance((PDAnnotation)annotation);
    }

    @Override
    public boolean supportsRect() {
        return true;
    }

    @Override
    public boolean supportsResize() {
        return this.supportsRect();
    }

    @Override
    public boolean supportsTransfer() {
        return true;
    }

    protected void unrotateTransferable(PDAnnotation annotation, int rotate) {
    }
}

