/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.markup;

import de.intarsys.pdf.app.annotation.markup.MarkupFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDEmbeddedFile;
import de.intarsys.pdf.pd.PDFileAttachmentAnnotation;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class MarkupFileAttachmentFactory
extends MarkupFactory {
    public static final Object ATTR_FILE = new Object();

    @Override
    protected PDAnnotation basicCreateAnnotation(PDPage page, CDSRectangle rect, Map attributes) {
        PDFileAttachmentAnnotation newAnnot = (PDFileAttachmentAnnotation)PDFileAttachmentAnnotation.META.createNew();
        return newAnnot;
    }

    @Override
    protected void createAnnotationState(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) throws ObjectCreationException {
        super.createAnnotationState(page, annotation, rect, attributes);
        annotation.setPrint(false);
        annotation.setColor(new float[]{1.0f, 1.0f, 0.0f});
        File file = (File)attributes.get(ATTR_FILE);
        PDFileAttachmentAnnotation faAnnot = (PDFileAttachmentAnnotation)annotation;
        PDFileSpecification fileSpec = (PDFileSpecification)PDFileSpecification.META.createNew();
        fileSpec.setFileSpecificationString(PDFileSpecification.DK_F, file.getName());
        faAnnot.setFileSpecification(fileSpec);
        faAnnot.setContents(file.getName());
        faAnnot.setSubject("File Attachment");
        PDEmbeddedFile embeddedFile = (PDEmbeddedFile)PDEmbeddedFile.META.createNew();
        try {
            byte[] bytes = FileTools.getBytes((File)file);
            embeddedFile.setBytes(bytes);
        }
        catch (IOException e) {
            throw new ObjectCreationException((Throwable)e);
        }
        fileSpec.setEmbeddedFile(PDFileSpecification.DK_F, embeddedFile);
    }

    @Override
    protected void createAnnotationStateFromShape(PDAnnotation annotation, Shape shape) {
    }

    public COSName getAnnotationType() {
        return PDFileAttachmentAnnotation.CN_Subtype_FileAttachment;
    }
}

