/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.CMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IdentityCMap
extends CMap {
    public static final COSName CN_Identity_H = COSName.constant("Identity-H");
    public static final COSName CN_Identity_V = COSName.constant("Identity-V");
    public static IdentityCMap SINGLETON = new IdentityCMap();

    public static CMap getSingleton(COSName name) {
        if (name.equals(CN_Identity_H)) {
            return SINGLETON;
        }
        if (name.equals(CN_Identity_V)) {
            return SINGLETON;
        }
        return null;
    }

    protected IdentityCMap() {
        super(null);
    }

    @Override
    public char[] getChars(int codepoint) {
        int decoded = this.getDecoded(codepoint);
        if (decoded == -1) {
            return null;
        }
        return new char[]{(char)decoded};
    }

    @Override
    public int getDecoded(int value) {
        return value;
    }

    @Override
    public int getEncoded(int character) {
        return character;
    }

    @Override
    public int getNextDecoded(InputStream is) throws IOException {
        int hb = is.read();
        int lb = is.read();
        if (hb == -1 || lb == -1) {
            return -1;
        }
        return (hb << 8) + lb;
    }

    @Override
    public int getNextEncoded(InputStream is) throws IOException {
        int hb = is.read();
        int lb = is.read();
        if (hb == -1 || lb == -1) {
            return -1;
        }
        return (hb << 8) + lb;
    }

    @Override
    public void putNextDecoded(OutputStream os, int character) throws IOException {
        os.write(character >> 8 & 0xFF);
        os.write(character & 0xFF);
    }

    @Override
    public void putNextEncoded(OutputStream os, int codepoint) throws IOException {
        os.write(codepoint >> 8 & 0xFF);
        os.write(codepoint & 0xFF);
    }
}

