/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectsession;

import de.intarsys.tools.objectsession.EntryBasedObjectSession;
import de.intarsys.tools.objectsession.IObjectSession;
import de.intarsys.tools.objectsession.NestedObjectSession;
import de.intarsys.tools.objectsession.ObjectSessionType;
import de.intarsys.tools.transaction.CommonResource;
import de.intarsys.tools.transaction.IResource;
import de.intarsys.tools.transaction.IResourceType;
import de.intarsys.tools.transaction.ResourceException;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjectSession
extends CommonResource<ObjectSession, ObjectSessionType>
implements IObjectSession {
    private List children = new ArrayList();

    protected ObjectSession(ObjectSessionType type, ObjectSession parent) {
        super((IResourceType)type, (IResource)parent);
    }

    protected void addSession(ObjectSession session) {
        this.children.add(session);
    }

    public final void commit() throws ResourceException {
        for (ObjectSession child : this.children) {
            child.commit();
        }
        this.doCommit();
    }

    @Override
    public IObjectSession createSession() {
        NestedObjectSession resource = new NestedObjectSession((ObjectSessionType)this.getType(), (EntryBasedObjectSession)this);
        return resource;
    }

    protected void doCommit() throws ResourceException {
    }

    protected void doRollback() throws ResourceException {
    }

    protected void doRollforward() throws ResourceException {
    }

    protected abstract boolean isChanged();

    @Override
    public boolean isEmpty() {
        return this.isEmptyChildren() && this.isEmptyLocal();
    }

    protected boolean isEmptyChildren() {
        for (ObjectSession child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isEmptyLocal();

    protected void removeSession(ObjectSession session) {
        this.children.remove(session);
    }

    public final void rollback() throws ResourceException {
        for (ObjectSession child : this.children) {
            child.rollback();
        }
        this.doRollback();
    }

    public final void rollforward() throws ResourceException {
        for (ObjectSession child : this.children) {
            child.rollforward();
        }
        this.doRollforward();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.toStringFlags(sb);
        sb.append("]-");
        sb.append(this.getClass().getName());
        return sb.toString();
    }

    protected void toStringFlags(StringBuilder sb) {
        if (this.isActive()) {
            sb.append("!");
        }
        if (this.isChanged()) {
            sb.append("*");
        }
        if (this.children != null) {
            sb.append(this.children.size());
        } else {
            sb.append("-");
        }
    }
}

