/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cli;

import de.intarsys.tools.cli.CLICommandline;
import de.intarsys.tools.cli.CLIOption;
import de.intarsys.tools.cli.ICLICommandline;

public class CLICommandlineParser {
    protected String canonicalizeToken(String token) {
        return token.replace('\u2013', '-');
    }

    public ICLICommandline parse(String[] args) {
        int i;
        CLICommandline commandline = new CLICommandline(args);
        if (args == null) {
            return commandline;
        }
        CLIOption currentOption = null;
        int len = args.length;
        for (i = 0; i < len; ++i) {
            String token = args[i];
            if ((token = this.canonicalizeToken(token)).startsWith("--") || token.startsWith("~~")) {
                String longName = token.substring(2);
                currentOption = new CLIOption(null, longName);
                if (token.startsWith("~~")) {
                    currentOption.setHidden(true);
                }
                commandline.addOption(currentOption);
                continue;
            }
            if (token.startsWith("-") || token.startsWith("~")) {
                String shortName = token.substring(1);
                currentOption = new CLIOption(shortName, null);
                if (token.startsWith("~")) {
                    currentOption.setHidden(true);
                }
                commandline.addOption(currentOption);
                continue;
            }
            if (currentOption == null) break;
            currentOption.addValue(token);
        }
        while (i < len) {
            commandline.addRemainingArg(args[i]);
            ++i;
        }
        return commandline;
    }
}

