/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.XMPSchemaBasic;
import org.jempbox.xmp.XMPSchemaBasicJobTicket;
import org.jempbox.xmp.XMPSchemaCameraRaw;
import org.jempbox.xmp.XMPSchemaDublinCore;
import org.jempbox.xmp.XMPSchemaDynamicMedia;
import org.jempbox.xmp.XMPSchemaEXIF;
import org.jempbox.xmp.XMPSchemaEXIFAux;
import org.jempbox.xmp.XMPSchemaEXIFForTIFF;
import org.jempbox.xmp.XMPSchemaMediaManagement;
import org.jempbox.xmp.XMPSchemaNull;
import org.jempbox.xmp.XMPSchemaPDF;
import org.jempbox.xmp.XMPSchemaPagedText;
import org.jempbox.xmp.XMPSchemaPhotoshop;
import org.jempbox.xmp.XMPSchemaRightsManagement;
import org.jempbox.xmp.property.PropertyResourceEvent;
import org.jempbox.xmp.property.PropertyResourceRef;
import org.jempbox.xmp.property.XMPSchemaPropertyBeatSpliceStretch;
import org.jempbox.xmp.property.XMPSchemaPropertyCFAPattern;
import org.jempbox.xmp.property.XMPSchemaPropertyColorant;
import org.jempbox.xmp.property.XMPSchemaPropertyDeviceSettings;
import org.jempbox.xmp.property.XMPSchemaPropertyDimensions;
import org.jempbox.xmp.property.XMPSchemaPropertyFlash;
import org.jempbox.xmp.property.XMPSchemaPropertyFont;
import org.jempbox.xmp.property.XMPSchemaPropertyJob;
import org.jempbox.xmp.property.XMPSchemaPropertyMarker;
import org.jempbox.xmp.property.XMPSchemaPropertyMedia;
import org.jempbox.xmp.property.XMPSchemaPropertyOECFSFR;
import org.jempbox.xmp.property.XMPSchemaPropertyProjectLink;
import org.jempbox.xmp.property.XMPSchemaPropertyResampleStretch;
import org.jempbox.xmp.property.XMPSchemaPropertyScheme;
import org.jempbox.xmp.property.XMPSchemaPropertyThumbnail;
import org.jempbox.xmp.property.XMPSchemaPropertyTime;
import org.jempbox.xmp.property.XMPSchemaPropertyTimeScaleStretch;
import org.jempbox.xmp.property.XMPSchemaPropertyTimecode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class XMPMetadata {
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_UTF16BE = "UTF-16BE";
    public static final String ENCODING_UTF16LE = "UTF-16LE";
    protected Document xmpDocument;
    protected String encoding = "UTF-8";
    protected Map<String, Class<?>> nsMappings = new HashMap();
    protected Map<String, Class<?>> datatypeMappings = new HashMap();

    public static XMPMetadata load(InputSource is) throws IOException {
        return new XMPMetadata(XMLUtil.parse(is));
    }

    public static XMPMetadata load(InputStream is) throws IOException {
        return new XMPMetadata(XMLUtil.parse(is));
    }

    public XMPMetadata() throws IOException {
        this.xmpDocument = XMLUtil.newDocument();
        ProcessingInstruction beginXPacket = this.xmpDocument.createProcessingInstruction("xpacket", "begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"");
        this.xmpDocument.appendChild(beginXPacket);
        Element xmpMeta = this.xmpDocument.createElementNS("adobe:ns:meta/", "x:xmpmeta");
        xmpMeta.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "adobe:ns:meta/");
        this.xmpDocument.appendChild(xmpMeta);
        Element rdf = this.xmpDocument.createElement("rdf:RDF");
        rdf.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        xmpMeta.appendChild(rdf);
        ProcessingInstruction endXPacket = this.xmpDocument.createProcessingInstruction("xpacket", "end=\"w\"");
        this.xmpDocument.appendChild(endXPacket);
        this.init();
    }

    public XMPMetadata(Document doc) {
        this.xmpDocument = doc;
        this.init();
    }

    public XMPSchemaBasicJobTicket addBasicJobTicketSchema() {
        XMPSchemaBasicJobTicket schema = new XMPSchemaBasicJobTicket(this);
        return (XMPSchemaBasicJobTicket)this.basicAddSchema(schema);
    }

    public XMPSchemaBasic addBasicSchema() {
        XMPSchemaBasic schema = new XMPSchemaBasic(this);
        return (XMPSchemaBasic)this.basicAddSchema(schema);
    }

    public XMPSchemaDublinCore addDublinCoreSchema() {
        XMPSchemaDublinCore schema = new XMPSchemaDublinCore(this);
        return (XMPSchemaDublinCore)this.basicAddSchema(schema);
    }

    public XMPSchemaDynamicMedia addDynamicMediaSchema() {
        XMPSchemaDynamicMedia schema = new XMPSchemaDynamicMedia(this);
        return (XMPSchemaDynamicMedia)this.basicAddSchema(schema);
    }

    public XMPSchemaMediaManagement addMediaManagementSchema() {
        XMPSchemaMediaManagement schema = new XMPSchemaMediaManagement(this);
        return (XMPSchemaMediaManagement)this.basicAddSchema(schema);
    }

    public XMPSchemaPagedText addPagedTextSchema() {
        XMPSchemaPagedText schema = new XMPSchemaPagedText(this);
        return (XMPSchemaPagedText)this.basicAddSchema(schema);
    }

    public XMPSchemaPDF addPDFSchema() {
        XMPSchemaPDF schema = new XMPSchemaPDF(this);
        return (XMPSchemaPDF)this.basicAddSchema(schema);
    }

    public XMPSchemaRightsManagement addRightsManagementSchema() {
        XMPSchemaRightsManagement schema = new XMPSchemaRightsManagement(this);
        return (XMPSchemaRightsManagement)this.basicAddSchema(schema);
    }

    public byte[] asByteArray() throws Exception {
        return XMLUtil.asByteArray(this.xmpDocument, this.encoding);
    }

    protected XMPSchema basicAddSchema(XMPSchema schema) {
        Element rdf = this.getRDFElement();
        rdf.appendChild(schema.getElement());
        return schema;
    }

    public XMPSchemaBasicJobTicket getBasicJobTicketSchema() throws IOException {
        return (XMPSchemaBasicJobTicket)this.getSchemaByClass(XMPSchemaBasicJobTicket.class);
    }

    public XMPSchemaBasic getBasicSchema() throws IOException {
        return (XMPSchemaBasic)this.getSchemaByClass(XMPSchemaBasic.class);
    }

    public XMPSchemaDublinCore getDublinCoreSchema() throws IOException {
        return (XMPSchemaDublinCore)this.getSchemaByClass(XMPSchemaDublinCore.class);
    }

    public XMPSchemaDynamicMedia getDynamicMediaSchema() throws IOException {
        return (XMPSchemaDynamicMedia)this.getSchemaByClass(XMPSchemaDynamicMedia.class);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public XMPSchemaMediaManagement getMediaManagementSchema() throws IOException {
        return (XMPSchemaMediaManagement)this.getSchemaByClass(XMPSchemaMediaManagement.class);
    }

    public XMPSchemaPagedText getPagedTextSchema() throws IOException {
        return (XMPSchemaPagedText)this.getSchemaByClass(XMPSchemaPagedText.class);
    }

    public XMPSchemaPDF getPDFSchema() throws IOException {
        return (XMPSchemaPDF)this.getSchemaByClass(XMPSchemaPDF.class);
    }

    private Element getRDFElement() {
        Element rdf = null;
        NodeList nodes = this.xmpDocument.getElementsByTagName("rdf:RDF");
        if (nodes.getLength() > 0) {
            rdf = (Element)nodes.item(0);
        }
        return rdf;
    }

    public XMPSchemaRightsManagement getRightsManagementSchema() throws IOException {
        return (XMPSchemaRightsManagement)this.getSchemaByClass(XMPSchemaRightsManagement.class);
    }

    protected XMPSchema getSchemaByClass(Class targetSchema) throws IOException {
        for (XMPSchema element : this.getSchemas()) {
            if (!element.getClass().getName().equals(targetSchema.getName())) continue;
            return element;
        }
        return null;
    }

    public List<XMPSchema> getSchemas() throws IOException {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        ArrayList<XMPSchema> retval = new ArrayList<XMPSchema>(schemaList.getLength());
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            boolean found = false;
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (!name.startsWith("xmlns:") || !this.nsMappings.containsKey(value)) continue;
                Class<?> schemaClass = this.nsMappings.get(value);
                try {
                    Constructor<?> ctor = schemaClass.getConstructor(Element.class, String.class);
                    retval.add((XMPSchema)ctor.newInstance(schema, name.substring(6)));
                    found = true;
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Error: Class " + schemaClass.getName() + " must have a constructor with the signature of " + schemaClass.getName() + "( org.w3c.dom.Element )");
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (found) continue;
            retval.add(new XMPSchemaNull(schema, null));
        }
        return retval;
    }

    public Document getXMPDocument() {
        return this.xmpDocument;
    }

    public boolean hasUnknownSchema() throws IOException {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (name.startsWith("xmlns:") && this.nsMappings.containsKey(value)) continue;
            }
        }
        return false;
    }

    private void init() {
        this.nsMappings.put("http://ns.adobe.com/pdf/1.3/", XMPSchemaPDF.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/", XMPSchemaBasic.class);
        this.nsMappings.put("http://purl.org/dc/elements/1.1/", XMPSchemaDublinCore.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/mm/", XMPSchemaMediaManagement.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/rights/", XMPSchemaRightsManagement.class);
        this.nsMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/", XMPSchemaDynamicMedia.class);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/t/pg/", XMPSchemaPagedText.class);
        this.nsMappings.put("http://ns.adobe.com/photoshop/1.0/", XMPSchemaPhotoshop.class);
        this.nsMappings.put("http://ns.adobe.com/camera-raw-settings/1.0/", XMPSchemaCameraRaw.class);
        this.nsMappings.put("http://ns.adobe.com/tiff/1.0/", XMPSchemaEXIFForTIFF.class);
        this.nsMappings.put("http://ns.adobe.com/exif/1.0/", XMPSchemaEXIF.class);
        this.nsMappings.put("http://ns.adobe.com/exif/1.0/aux/", XMPSchemaEXIFAux.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/g", XMPSchemaPropertyColorant.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/Identifier/qual/1.0/", XMPSchemaPropertyScheme.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/sType/Dimensions#", XMPSchemaPropertyDimensions.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/sType/Font#", XMPSchemaPropertyFont.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/sType/ResourceEvent#", PropertyResourceEvent.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/sType/ResourceRef#", PropertyResourceRef.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/g/img/", XMPSchemaPropertyThumbnail.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/sType/Version#", PropertyResourceEvent.class);
        this.datatypeMappings.put("http://ns.adobe.com/exif/1.0/ds", XMPSchemaPropertyDeviceSettings.class);
        this.datatypeMappings.put("http://ns.adobe.com/exif/1.0/cfa", XMPSchemaPropertyCFAPattern.class);
        this.datatypeMappings.put("http://ns.adobe.com/exif/1.0/oecf", XMPSchemaPropertyOECFSFR.class);
        this.datatypeMappings.put("http://ns.adobe.com/exif/1.0/flash", XMPSchemaPropertyFlash.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/tss", XMPSchemaPropertyTimeScaleStretch.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/tc", XMPSchemaPropertyTimecode.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/t", XMPSchemaPropertyTime.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/pl", XMPSchemaPropertyProjectLink.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/rs", XMPSchemaPropertyResampleStretch.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/md", XMPSchemaPropertyMedia.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/ma", XMPSchemaPropertyMarker.class);
        this.datatypeMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/bss", XMPSchemaPropertyBeatSpliceStretch.class);
        this.datatypeMappings.put("http://ns.adobe.com/xap/1.0/sType/job#", XMPSchemaPropertyJob.class);
    }

    public void write(OutputStream output) throws Exception {
        XMLUtil.write(this.xmpDocument, output, this.encoding);
    }

    public void setEncoding(String xmlEncoding) {
        this.encoding = xmlEncoding;
    }
}

