/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.xml;

import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import java.io.IOException;
import java.io.Reader;

public class EntityDecoder
extends DirectTagReader {
    private static final IDirectTagHandler ENTITY_HANDLER = new IDirectTagHandler(){

        @Override
        public Object endTag(String tagContent, Object context) throws IOException {
            try {
                if (tagContent.startsWith("#")) {
                    char c = (char)Integer.parseInt(tagContent.substring(1), 10);
                    return new String(new char[]{c});
                }
                if ("amp".equals(tagContent)) {
                    return EntityDecoder.ENTITY_START;
                }
                if ("lt".equals(tagContent)) {
                    return "<";
                }
                if ("gt".equals(tagContent)) {
                    return ">";
                }
                if ("apos".equals(tagContent)) {
                    return "'";
                }
                if ("auml".equals(tagContent)) {
                    return "\u00e4";
                }
                if ("Auml".equals(tagContent)) {
                    return "\u00c4";
                }
                if ("ouml".equals(tagContent)) {
                    return "\u00f6";
                }
                if ("Ouml".equals(tagContent)) {
                    return "\u00d6";
                }
                if ("uuml".equals(tagContent)) {
                    return "\u00fc";
                }
                if ("Uuml".equals(tagContent)) {
                    return "\u00dc";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tagContent;
        }

        @Override
        public void setLocationProvider(ILocationProvider locationProvider) {
        }

        @Override
        public void startTag() {
        }
    };
    private static final String ENTITY_END = ";";
    private static final String ENTITY_START = "&";

    public EntityDecoder(Reader reader) {
        super(reader, ENTITY_HANDLER, null);
        this.setStartTag(ENTITY_START);
        this.setEndTag(ENTITY_END);
    }

    public EntityDecoder(Reader reader, boolean escape) {
        super(reader, ENTITY_HANDLER, null, escape);
        this.setStartTag(ENTITY_START);
        this.setEndTag(ENTITY_END);
    }
}

