/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui.toolkit;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.ui.toolkit.CommonToolkit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebToolkit
extends CommonToolkit {
    private static final Logger Log = LoggerFactory.getLogger(WebToolkit.class);
    private Thread workerThread;
    private final ExecutorService executorServiceWorker = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            WebToolkit.this.workerThread = new Thread(r, "headless worker");
            WebToolkit.this.workerThread.setDaemon(true);
            WebToolkit.this.workerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    Log.warn("uncaught exception in " + t, e);
                }
            });
            WebToolkit.this.workerThread.setPriority(5);
            return WebToolkit.this.workerThread;
        }
    });

    public WebToolkit() {
        this.setSilent(false);
    }

    @Override
    public void beep() {
    }

    protected ExecutorService getExecutorServiceWorker() {
        return this.executorServiceWorker;
    }

    @Override
    protected String getToolkitID() {
        return "web";
    }

    @Override
    protected String getToolkitIDFallback() {
        return "silent";
    }

    @Override
    public void invokeInUI(Runnable runnable) {
        this.invokeNow(runnable);
    }

    @Override
    public void invokeLater(Runnable runnable) {
        this.getExecutorServiceWorker().submit(runnable);
    }

    @Override
    public void invokeNow(Runnable runnable) {
        if (Thread.currentThread() == this.workerThread) {
            runnable.run();
            return;
        }
        Future<?> result = null;
        result = this.getExecutorServiceWorker().submit(runnable);
        ExceptionTools.futureSimpleGet(result);
    }

    @Override
    public void invokeUpdate(Runnable runnable) {
        this.invokeNow(runnable);
    }
}

