/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.ITransaction;
import de.intarsys.tools.transaction.ITransactionManager;
import de.intarsys.tools.transaction.ThreadLocalTransactionManager;
import de.intarsys.tools.transaction.TransactionException;
import de.intarsys.tools.transaction.TransactionManager;

public class ThreadExclusiveTransactionManager
implements ITransactionManager {
    private ITransactionManager mainManager;
    private Thread thread;
    private ITransactionManager exclusiveManager;

    public static ThreadExclusiveTransactionManager install() {
        Thread thread = Thread.currentThread();
        ThreadExclusiveTransactionManager transactionManager = new ThreadExclusiveTransactionManager(thread, TransactionManager.get());
        TransactionManager.set(transactionManager);
        return transactionManager;
    }

    public ThreadExclusiveTransactionManager(Thread thread, ITransactionManager delegate) {
        this.thread = thread;
        this.mainManager = delegate;
        this.exclusiveManager = new ThreadLocalTransactionManager();
    }

    @Override
    public void begin() throws TransactionException {
        this.getResponsible().begin();
    }

    @Override
    public void commit() throws TransactionException {
        this.getResponsible().commit();
    }

    @Override
    public void commitResume() throws TransactionException {
        this.getResponsible().commitResume();
    }

    protected ITransactionManager getResponsible() {
        if (Thread.currentThread() == this.thread) {
            return this.exclusiveManager;
        }
        return this.mainManager;
    }

    @Override
    public ITransaction getTransaction() {
        return this.getResponsible().getTransaction();
    }

    public void restore() {
        TransactionManager.set(this.mainManager);
    }

    @Override
    public void resume(ITransaction tx) throws TransactionException {
        this.getResponsible().resume(tx);
    }

    @Override
    public void rollback() throws TransactionException {
        this.getResponsible().rollback();
    }

    @Override
    public void rollbackResume() throws TransactionException {
        this.getResponsible().rollbackResume();
    }

    @Override
    public ITransaction suspend() throws TransactionException {
        return this.getResponsible().suspend();
    }
}

