/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.collection.ArrayIterator;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Args
implements IArgs {
    private static final Binding[] EMPTY = new Binding[0];
    private static final Object UNDEFINED = new Object();
    private Binding[] entries = EMPTY;
    private int ptr;
    private final boolean indexed;

    public static Args create() {
        return new Args();
    }

    public static Args createIndexed() {
        return new Args(true);
    }

    public static Args createIndexed(Object ... values) {
        return new Args(values);
    }

    public static Args createNamed(Object ... keyValue) {
        Args args = new Args(false);
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("even number of arguments required");
        }
        int i = 0;
        while (i < keyValue.length) {
            String key = String.valueOf(keyValue[i++]);
            Object value = null;
            if (i < keyValue.length) {
                value = keyValue[i++];
            }
            ArgTools.putPath(args, key, value);
        }
        return args;
    }

    protected static IArgs instanceSpecToArgs(Object spec) {
        if (spec instanceof InstanceSpec) {
            IArgs args = ((InstanceSpec)spec).toArgs();
            return args;
        }
        if (spec instanceof IArgs) {
            IArgs args = (IArgs)spec;
            return args;
        }
        Args args = Args.create();
        if (spec instanceof String || spec instanceof Class || spec instanceof IFactory) {
            args.put("factory", spec);
        }
        return args;
    }

    protected static boolean isInstanceSpec(Object oldValue) {
        if (oldValue instanceof InstanceSpec) {
            return true;
        }
        if (oldValue instanceof IArgs) {
            IArgs tempArgs = (IArgs)oldValue;
            if (tempArgs.get("args") != null) {
                return true;
            }
            if (tempArgs.get("factory") != null) {
                return true;
            }
        }
        return false;
    }

    protected static Object toArgValue(Object value) {
        if (value instanceof InstanceSpec) {
            return ((InstanceSpec)value).toArgs();
        }
        return value;
    }

    public Args() {
        this(false);
    }

    protected Args(Args pArgs) {
        this(!pArgs.isNamed());
        if (pArgs == null) {
            return;
        }
        this.ptr = pArgs.ptr;
        if (this.ptr > 0) {
            this.entries = new Binding[this.ptr];
            for (int i = 0; i < this.ptr; ++i) {
                Binding tempEntry = pArgs.entries[i];
                Object value = tempEntry.value;
                this.entries[i] = value instanceof IArgs ? new Binding(tempEntry.name, ((IArgs)value).copy()) : new Binding(tempEntry.name, value);
            }
        }
    }

    protected Args(boolean indexed) {
        this.indexed = indexed;
    }

    public Args(List<Object> values) {
        this(false);
        ArgTools.putAllDeep((IArgs)this, values);
    }

    public Args(Map<String, Object> values) {
        this(false);
        ArgTools.putAllDeep((IArgs)this, values);
    }

    public Args(Object ... values) {
        this(true);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.add(values[i]);
            }
        }
    }

    @Override
    public IArgs.IBinding add(Object object) {
        this.ensureCapacity(this.ptr);
        Binding tempBinding = new Binding(null, object);
        this.entries[this.ptr++] = tempBinding;
        return tempBinding;
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new ArrayIterator<IArgs.IBinding>(this.entries, this.ptr);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.ptr; ++i) {
            this.entries[i] = null;
        }
        this.ptr = 0;
    }

    @Override
    public IArgs copy() {
        return new Args(this);
    }

    @Override
    public IArgs.IBinding declare(String name) {
        if (name.endsWith("Args") && name.length() > 4) {
            IArgs spec = this.getAsInstanceSpecArgs(name);
            return spec.declare("args");
        }
        Binding tempBinding = this.getBinding(name);
        if (tempBinding != null) {
            return tempBinding;
        }
        for (int i = 0; i < this.ptr; ++i) {
            tempBinding = this.entries[i];
            if (tempBinding.name != null) continue;
            tempBinding.name = name;
            return tempBinding;
        }
        return this.put(name, UNDEFINED);
    }

    protected void ensureCapacity(int min) {
        if (min >= this.entries.length) {
            Binding[] newEntries = new Binding[min + 4];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            this.entries = newEntries;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IArgs) {
            IArgs other = (IArgs)obj;
            int size = this.size();
            if (other.size() != size) {
                return false;
            }
            for (int index = 0; index < size; ++index) {
                String name;
                Object otherValue;
                Binding binding = this.entries[index];
                Object value = binding.getValue();
                if (LangTools.equals(value, otherValue = (name = binding.getName()) == null ? other.get(index) : other.get(name))) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index >= this.ptr) {
            return null;
        }
        return this.entries[index].getValue();
    }

    @Override
    public Object get(int index, Object defaultValue) {
        if (index < 0 || index >= this.ptr) {
            return defaultValue;
        }
        if (this.entries[index].isDefined()) {
            return this.entries[index].value;
        }
        return defaultValue;
    }

    @Override
    public Object get(String name) {
        if (name.endsWith("Args") && name.length() > 4) {
            Object tempValue;
            String tempName = name.substring(0, name.length() - 4);
            Binding entry = this.getBinding(tempName);
            if (entry != null && (tempValue = entry.getValue()) instanceof IArgs) {
                IArgs args = (IArgs)tempValue;
                return args.get("args");
            }
            return null;
        }
        Binding entry = this.getBinding(name);
        return entry == null ? null : entry.getValue();
    }

    @Override
    public Object get(String name, Object defaultValue) {
        Object result = this.get(name);
        return result == null ? defaultValue : result;
    }

    protected IArgs getAsInstanceSpecArgs(String name) {
        String tempName = name.substring(0, name.length() - 4);
        Binding oldBinding = this.getBinding(tempName);
        Object oldValue = oldBinding == null ? null : oldBinding.getValue();
        IArgs spec = Args.instanceSpecToArgs(oldValue);
        this.put(tempName, (Object)spec);
        return spec;
    }

    protected Binding getBinding(String name) {
        for (int i = 0; i < this.ptr; ++i) {
            Binding entry = this.entries[i];
            if (!name.equals(entry.name)) continue;
            return entry;
        }
        return null;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        for (IArgs.IBinding binding : this) {
            if (binding.getName() != null) {
                sb.append(binding.getName().hashCode());
            }
            sb.append('@');
            if (binding.getValue() != null) {
                sb.append(binding.getValue().hashCode());
            }
            sb.append('#');
        }
        return sb.toString().hashCode();
    }

    @Override
    public boolean isDefined(int index) {
        if (index < 0 || index >= this.ptr) {
            return false;
        }
        return this.entries[index].isDefined();
    }

    @Override
    public boolean isDefined(String name) {
        if (name.endsWith("Args") && name.length() > 4) {
            Object tempValue;
            String tempName = name.substring(0, name.length() - 4);
            Binding entry = this.getBinding(tempName);
            if (entry != null && entry.isDefined() && (tempValue = entry.getValue()) instanceof IArgs) {
                IArgs args = (IArgs)tempValue;
                return args.isDefined("args");
            }
            return false;
        }
        Binding binding = this.getBinding(name);
        return binding != null && binding.isDefined();
    }

    @Override
    public boolean isNamed() {
        for (IArgs.IBinding binding : this) {
            if (binding.getName() == null) continue;
            return true;
        }
        return this.size() == 0 && !this.indexed;
    }

    @Override
    public Iterator<IArgs.IBinding> iterator() {
        return this.bindings();
    }

    @Override
    public Set<String> names() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.ptr; ++i) {
            Binding entry = this.entries[i];
            if (entry.name == null) continue;
            result.add(entry.name);
        }
        return result;
    }

    @Override
    public IArgs.IBinding put(int index, Object value) {
        Binding tempBinding;
        if (index >= this.ptr) {
            this.ensureCapacity(index);
            for (int i = this.ptr; i < index; ++i) {
                this.entries[i] = new Binding(null);
            }
            this.entries[index] = tempBinding = new Binding(null, value);
            this.ptr = index + 1;
        } else {
            tempBinding = this.entries[index];
            this.entries[index].setValue(value);
        }
        return tempBinding;
    }

    @Override
    public IArgs.IBinding put(String name, Object value) {
        if (name.endsWith("Args") && name.length() > 4) {
            IArgs spec = this.getAsInstanceSpecArgs(name);
            return spec.put("args", value);
        }
        Binding binding = this.getBinding(name);
        if (binding != null) {
            Object oldValue = binding.getValue();
            if (Args.isInstanceSpec(oldValue) && value instanceof String) {
                IArgs spec = Args.instanceSpecToArgs(oldValue);
                binding.setValue(spec);
                return spec.put("factory", value);
            }
            binding.setValue(value);
            return binding;
        }
        this.ensureCapacity(this.ptr);
        binding = new Binding(name, value);
        this.entries[this.ptr++] = binding;
        return binding;
    }

    @Override
    public int size() {
        return this.ptr;
    }

    public String toString() {
        return ArgTools.toPrintString(this, "");
    }

    @Override
    public void undefine(int index) {
        if (index < this.ptr) {
            this.entries[index].setValue(UNDEFINED);
        }
    }

    @Override
    public void undefine(String name) {
        if (name.endsWith("Args") && name.length() > 4) {
            IArgs spec = this.getAsInstanceSpecArgs(name);
            spec.undefine("args");
        } else {
            Binding binding = this.getBinding(name);
            if (binding != null) {
                binding.setValue(UNDEFINED);
            }
        }
    }

    static class Binding
    implements IArgs.IBinding {
        protected String name;
        protected Object value;

        protected Binding(String name) {
            this.name = name;
            this.value = UNDEFINED;
        }

        protected Binding(String name, Object value) {
            this.name = name;
            this.value = Args.toArgValue(value);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value == UNDEFINED ? null : this.value;
        }

        @Override
        public boolean isDefined() {
            return this.value != UNDEFINED;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void setValue(Object pValue) {
            this.value = Args.toArgValue(pValue);
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }
}

