/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.format;

import de.intarsys.tools.format.LogTuple;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public final class Format {
    private static final char BRACKET_RIGHT = ']';
    private static final char BRACKET_LEFT = '[';
    private static final String COMMA = ", ";
    private static final int BUFFER_SIZE = 50;
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map<Object[], Object> seenMap) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            Format.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            Format.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            Format.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            Format.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            Format.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            Format.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            Format.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            Format.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            Format.doubleArrayAppend(sbuf, (double[])o);
        } else {
            Format.objectArrayAppend(sbuf, (Object[])o, seenMap);
        }
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    protected static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    protected static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    protected static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    public static LogTuple log(String pattern, Object[] argArray) {
        if (argArray == null) {
            return new LogTuple(pattern);
        }
        Throwable throwableCandidate = Format.getThrowableCandidate(argArray);
        if (pattern == null) {
            return new LogTuple(null, throwableCandidate);
        }
        return new LogTuple(Format.simple(pattern, argArray), throwableCandidate);
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                Format.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(COMMA);
            }
            seenMap.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    public static String printf(String pattern, Object ... argArray) {
        return new Formatter().format(pattern, argArray).toString();
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t) {
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(COMMA);
        }
        sbuf.append(']');
    }

    public static String simple(String pattern, Object ... argArray) {
        if (argArray == null || argArray.length == 0) {
            return pattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(pattern.length() + 50);
        for (int k = 0; k < argArray.length; ++k) {
            int j = pattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return pattern;
                }
                sbuf.append(pattern.substring(i, pattern.length()));
                return sbuf.toString();
            }
            if (Format.isEscapedDelimeter(pattern, j)) {
                if (!Format.isDoubleEscaped(pattern, j)) {
                    --k;
                    sbuf.append(pattern.substring(i, j - 1));
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(pattern.substring(i, j - 1));
                Format.deeplyAppendParameter(sbuf, argArray[k], new HashMap<Object[], Object>());
                i = j + 2;
                continue;
            }
            sbuf.append(pattern.substring(i, j));
            Format.deeplyAppendParameter(sbuf, argArray[k], new HashMap<Object[], Object>());
            i = j + 2;
        }
        sbuf.append(pattern.substring(i, pattern.length()));
        return sbuf.toString();
    }

    private Format() {
    }
}

