/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.CommonFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import de.intarsys.tools.reflect.IInvocationSupport;
import de.intarsys.tools.reflect.ObjectCreationException;

public abstract class CommonDispatchingFactory<T>
extends CommonFactory<T> {
    @Override
    public T createInstance(IArgs args) throws ObjectCreationException {
        Object object = null;
        try {
            object = this.getDoubleDispatchTarget(args);
            if (object == null) {
                throw new ObjectCreationException("factory '" + this.getId() + "' double dispatch target may not be null");
            }
            if (object instanceof IInvocationSupport) {
                Object object2 = ((IInvocationSupport)object).invoke(this.getMethodName(), args);
                return (T)object2;
            }
            Object object3 = ObjectModelTools.invoke(object, this.getMethodName(), args);
            return (T)object3;
        }
        catch (Exception e) {
            throw ExceptionTools.unwrapTyped(e, ObjectCreationException.class);
        }
        finally {
            if (object != null) {
                this.releaseDoubleDispatchTarget(object);
            }
        }
    }

    protected abstract Object getDoubleDispatchTarget(IArgs var1) throws Exception;

    protected abstract String getMethodName();

    protected void releaseDoubleDispatchTarget(Object object) {
    }
}

