/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.bean;

import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.bean.IBeanContainer;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.proxy.IProxy;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBeanContainer
implements IBeanContainer {
    private static final Logger Log = LoggerFactory.getLogger(StandardBeanContainer.class);
    private final Map<String, Object> beansById = new HashMap<String, Object>(500);
    private final List<Object> beanList = new ArrayList<Object>(1000);
    private final Map<String, List> beansByRole = new HashMap<String, List>(100);

    protected void addBeanToRole(String role, Object bean) {
        List beans = this.beansByRole.computeIfAbsent(role, key -> new ArrayList());
        beans.add(bean);
    }

    @Override
    public synchronized <T> T lookupBean(Class<T> expectedClass) {
        for (Object object : this.beanList) {
            if (!expectedClass.isInstance(object)) continue;
            return (T)this.realize(object);
        }
        return null;
    }

    @Override
    public synchronized <T> T lookupBean(String id, Class<T> expectedClass) {
        Object bean = this.beansById.get(id);
        return (T)this.realize(bean);
    }

    @Override
    public synchronized <T> List<T> lookupBeans(Class<T> expectedClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : this.beanList) {
            if (!expectedClass.isInstance(object)) continue;
            result.add(this.realize(object));
        }
        return result;
    }

    @Override
    public synchronized <T> List<T> lookupBeans(String role, Class<T> expectedClass) {
        List beans = this.beansByRole.get(role);
        if (beans == null) {
            return new ArrayList();
        }
        for (int i = 0; i < beans.size(); ++i) {
            beans.set(i, this.realize(beans.get(i)));
        }
        return beans;
    }

    protected Object realize(Object bean) {
        if (bean instanceof IProxy) {
            return ((IProxy)bean).getRealized();
        }
        return bean;
    }

    @Override
    public synchronized void registerBean(String id, String role, Object object) {
        Class<?> clazz;
        BeanComponent beanRole;
        this.beanList.add(object);
        if (id != null) {
            this.beansById.put(id, object);
        }
        if (role == null && (beanRole = (clazz = object.getClass()).getAnnotation(BeanComponent.class)) != null) {
            role = beanRole.role();
        }
        if (role != null) {
            this.addBeanToRole(role, object);
        }
    }

    @Override
    public synchronized void shutdown() {
        ArrayList<Object> beans = new ArrayList<Object>(this.beanList);
        ReverseListIterator<Object> it = new ReverseListIterator<Object>(beans);
        while (it.hasNext()) {
            this.shutdown(it.next());
        }
    }

    protected void shutdown(Object object) {
        Method[] methods;
        Class<?> clazz = object.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (method.getAnnotation(PreDestroy.class) == null) continue;
            try {
                method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                Log.warn("exception when shutting down", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void unregisterBean(String id) {
        Object bean = this.beansById.remove(id);
        this.beanList.remove(bean);
        for (List roleBeanList : this.beansByRole.values()) {
            roleBeanList.remove(bean);
        }
    }
}

