/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.action;

import de.intarsys.tools.action.Action;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.IInvocationSupport;
import de.intarsys.tools.reflect.IInvocationSupportAccessibility;
import de.intarsys.tools.reflect.MethodException;

public class InvocationSupportAction
extends Action {
    private IInvocationSupport invocationSupport;
    private boolean definedEnabled;
    private boolean definedChecked;
    private String invocationName;

    public InvocationSupportAction() {
    }

    public InvocationSupportAction(Object owner) {
        super(owner);
    }

    public InvocationSupportAction(Object owner, boolean checked) {
        super(owner, checked);
    }

    public InvocationSupportAction(String id, Object owner) {
        super(id, owner);
    }

    public InvocationSupportAction(String id, Object owner, boolean checked) {
        super(id, owner, checked);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        String value = element.attributeValue("invoke", null);
        if (value != null) {
            this.setInvocationName(value);
        }
    }

    public String getInvocationName() {
        if (this.invocationName == null) {
            return this.getId();
        }
        return this.invocationName;
    }

    public IInvocationSupport getInvocationSupport() {
        return this.invocationSupport;
    }

    protected boolean isDefinedChecked() {
        return this.definedChecked;
    }

    protected boolean isDefinedEnabled() {
        return this.definedEnabled;
    }

    @Override
    public boolean isEnabled(IFunctorCall call) {
        if (this.isDefinedEnabled()) {
            return super.isEnabled(call);
        }
        if (this.getInvocationSupport() instanceof IInvocationSupportAccessibility) {
            try {
                return ((IInvocationSupportAccessibility)((Object)this.getInvocationSupport())).isInvokeEnabled(this.getInvocationName(), call.getArgs());
            }
            catch (MethodException e) {
                return false;
            }
        }
        return super.isEnabled(call);
    }

    @Override
    public Object perform(IFunctorCall call) throws FunctorException {
        if (this.getInvocationSupport() != null) {
            try {
                return this.getInvocationSupport().invoke(this.getInvocationName(), call.getArgs());
            }
            catch (MethodException e) {
                Throwable cause;
                Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
                if (cause instanceof FunctorException) {
                    throw (FunctorException)cause;
                }
                throw new FunctorExecutionException(cause);
            }
        }
        return super.perform(call);
    }

    @Override
    public void setChecked(boolean checked) {
        this.setDefinedChecked(true);
        super.setChecked(checked);
    }

    protected void setDefinedChecked(boolean definedChecked) {
        this.definedChecked = definedChecked;
    }

    protected void setDefinedEnabled(boolean definedEnabled) {
        this.definedEnabled = definedEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setDefinedEnabled(true);
        super.setEnabled(enabled);
    }

    public void setInvocationName(String invocationName) {
        this.invocationName = invocationName;
    }

    @Override
    public void setOwner(Object owner) {
        super.setOwner(owner);
        if (owner instanceof IInvocationSupport) {
            this.invocationSupport = (IInvocationSupport)owner;
        }
    }

    @Override
    public String toString() {
        try {
            return "InvocationSupportAction '" + this.getId() + "'";
        }
        catch (RuntimeException e) {
            return "<unprintable InvocationSupportAction>";
        }
    }
}

