/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.crl;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.Extensions;
import de.intarsys.asn1.x509.Name;
import de.intarsys.asn1.x509.Time;
import de.intarsys.asn1.x509.crl.CertListEntries;
import org.bouncycastle.asn1.ASN1Integer;

public class TBSCertList
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public Extensions getExtensions() {
        int index = 5;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        if (!this.isNextUpdateExistent()) {
            --index;
        }
        return (Extensions)Extensions.FACTORY.create(this.getValueHolder().getNextTaggedGetChild(index, 0, true));
    }

    public Name getIssuer() {
        ASN1ValueHolder issuer = this.isVersionObjectExistent() ? this.getValueHolder().getChild(2) : this.getValueHolder().getChild(1);
        return (Name)Name.FACTORY.create(issuer);
    }

    public void getIssuer(Name issuer) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(2, issuer);
        } else {
            this.getValueHolder().setChild(1, issuer);
        }
    }

    public Time getNextUpdate() {
        ASN1ValueHolder o = this.isVersionObjectExistent() ? this.getValueHolder().getChild(4) : this.getValueHolder().getChild(3);
        if (!o.isScalar()) {
            return null;
        }
        return (Time)Time.FACTORY.create(o);
    }

    public CertListEntries getRevokedCertificates() {
        int index = 5;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        if (!this.isNextUpdateExistent()) {
            --index;
        }
        return (CertListEntries)CertListEntries.FACTORY.create(this.getValueHolder().getNextNotTagged(index));
    }

    public AlgorithmIdentifier getSignature() {
        ASN1ValueHolder vh = this.isVersionObjectExistent() ? this.getValueHolder().getChild(1) : this.getValueHolder().getChild(0);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(vh);
    }

    public Time getThisUpdate() {
        ASN1ValueHolder o = this.isVersionObjectExistent() ? this.getValueHolder().getChild(3) : this.getValueHolder().getChild(2);
        return (Time)Time.FACTORY.create(o);
    }

    public Version getVersion() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        if (ASN1Tools.isInstanceOf(o, ASN1Integer.class)) {
            return (Version)Version.FACTORY.create(o);
        }
        return Version.create(1);
    }

    private boolean isNextUpdateExistent() {
        ASN1ValueHolder o = this.isVersionObjectExistent() ? this.getValueHolder().getChild(4) : this.getValueHolder().getChild(3);
        return o.isScalar();
    }

    private boolean isRevokedCertificatesExistent() {
        int index = 5;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        if (!this.isNextUpdateExistent()) {
            --index;
        }
        return this.getValueHolder().getNextNotTagged(index) != null;
    }

    private boolean isVersionObjectExistent() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        return ASN1Tools.isInstanceOf(o, ASN1Integer.class);
    }

    public void setExtensions(Extensions extensions) {
        int index = 6;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        if (!this.isNextUpdateExistent()) {
            --index;
        }
        if (!this.isRevokedCertificatesExistent()) {
            --index;
        }
        ASN1TaggedHolder vh = new ASN1TaggedHolder(true, 0, extensions);
        this.getValueHolder().setChild(index, vh);
    }

    public void setIssuer(Name issuer) {
        int index = 2;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        this.getValueHolder().setChild(index, issuer);
    }

    public void setNextUpdate(Time nextUpdate) {
        ASN1ValueHolder o;
        int index = 4;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        if ((o = this.getValueHolder().getChild(index)) == null || o.isScalar()) {
            this.getValueHolder().setChild(index, nextUpdate);
        } else {
            this.getValueHolder().insertChild(index, nextUpdate);
        }
    }

    public void setRevokedCertificates(CertListEntries revokedCertificates) {
        ASN1ValueHolder o;
        int index = 5;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        if (!this.isNextUpdateExistent()) {
            --index;
        }
        if ((o = this.getValueHolder().getChild(index)) == null || !o.isTagged()) {
            this.getValueHolder().setChild(index, revokedCertificates);
        } else {
            this.getValueHolder().insertChild(index, revokedCertificates);
        }
    }

    public void setSignature(AlgorithmIdentifier signature) {
        int index = 1;
        if (!this.isVersionObjectExistent()) {
            --index;
        }
        this.getValueHolder().setChild(index, signature);
    }

    public void setThisUpdate(Time thisUpdate) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(3, thisUpdate);
        } else {
            this.getValueHolder().setChild(2, thisUpdate);
        }
    }

    public void setVersion(Version version) {
        if (this.isVersionObjectExistent()) {
            this.getValueHolder().setChild(0, version);
        } else {
            this.getValueHolder().insertChild(0, version);
        }
    }

    public static class Factory
    extends ASN1Based.Factory<TBSCertList> {
    }
}

