/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1ValueHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;

public abstract class ASN1CollectionHolder
extends ASN1ValueHolder {
    protected List<ASN1ValueHolder> objects;

    protected static List<ASN1ValueHolder> createCollection(ASN1ValueHolder container, Iterator it) {
        ArrayList<ASN1ValueHolder> result = new ArrayList<ASN1ValueHolder>();
        while (it.hasNext()) {
            ASN1ValueHolder temp = ASN1ValueHolder.create((ASN1Encodable)it.next());
            temp.setContainer(container);
            result.add(temp);
        }
        return result;
    }

    protected ASN1CollectionHolder() {
        this(new ArrayList<ASN1Encodable>());
    }

    public ASN1CollectionHolder(ASN1Primitive value, Iterator it) {
        super(value);
        this.objects = ASN1CollectionHolder.createCollection(this, it);
    }

    protected ASN1CollectionHolder(List<ASN1Encodable> list) {
        this.setChanged(true);
        this.objects = ASN1CollectionHolder.createCollection(this, list.iterator());
    }

    @Override
    public void addChild(ASN1Encodable value) {
        this.setChanged(true);
        ASN1ValueHolder temp = ASN1ValueHolder.create(value);
        temp.setContainer(this);
        this.objects.add(temp);
    }

    public ASN1EncodableVector asASN1EncodableVector() {
        ASN1EncodableVector result = new ASN1EncodableVector();
        for (ASN1ValueHolder object : this.objects) {
            result.add((ASN1Encodable)object);
        }
        return result;
    }

    protected ASN1EncodableVector createASN1Primitives() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (ASN1Encodable aSN1Encodable : this.objects) {
            if (aSN1Encodable == null) continue;
            v.add((ASN1Encodable)aSN1Encodable.toASN1Primitive());
        }
        return v;
    }

    protected void ensureSize(List list, int size) {
        int required = size - list.size();
        for (int i = 0; i < required; ++i) {
            list.add(null);
        }
    }

    @Override
    public ASN1ValueHolder getChild() {
        return this.getChild(0);
    }

    @Override
    public ASN1ValueHolder getChild(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.objects.get(index);
    }

    protected List<ASN1ValueHolder> getObjects() {
        return new ArrayList<ASN1ValueHolder>(this.objects);
    }

    @Override
    public void insertChild(int index, ASN1Encodable value) {
        this.setChanged(true);
        if (index >= this.size()) {
            this.setChild(index, value);
            return;
        }
        int oldSize = this.size();
        this.ensureSize(this.objects, oldSize + 1);
        for (int i = oldSize - 1; i >= index; --i) {
            ASN1ValueHolder tmp = this.objects.get(i);
            this.objects.set(i + 1, tmp);
        }
        ASN1ValueHolder temp = ASN1ValueHolder.create(value);
        temp.setContainer(this);
        this.objects.set(index, temp);
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        for (ASN1ValueHolder object : this.objects) {
            if (!object.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ASN1ValueHolder> iterator() {
        return new ArrayList<ASN1ValueHolder>(this.objects).iterator();
    }

    @Override
    public void setChild(ASN1Encodable newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChild(int index, ASN1Encodable value) {
        this.setChanged(true);
        this.ensureSize(this.objects, index + 1);
        ASN1ValueHolder temp = ASN1ValueHolder.create(value);
        temp.setContainer(this);
        this.objects.set(index, temp);
    }

    @Override
    public int size() {
        return this.objects.size();
    }
}

