/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicensePropertyUnitPerTime;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.time.Instant;

public class LicensePropertyUnitPerMinute
extends LicensePropertyUnitPerTime {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final long MILLISPERMINUTE = 60000L;

    @Override
    protected long getAccountingPeriod() {
        return 60000L;
    }

    @Override
    public String getId() {
        return "minute";
    }

    @Override
    public String getLabel() {
        return Msg.getString("LicensePropertyUnitPerMinute.Label", new Object[0]);
    }

    @Override
    protected void handleRestrictionExceededDefault(LicenseAccount account, int maxTokens, float spentTokens) throws LicenseException {
        if (maxTokens == 0) {
            throw new LicenseException(this.getExceededMessage(account, maxTokens));
        }
        Instant lastAccess = LicensePropertyUnitPerMinute.getLastAccess(account);
        long current = System.currentTimeMillis();
        long delay = this.getAccountingPeriod() - current + lastAccess.toEpochMilli();
        this.delay(account, maxTokens, (int)delay);
        this.resetAccount(account);
    }
}

