/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorSerializer;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CertificateFilterPrincipalFilter;
import de.intarsys.security.device.common.PrincipalEqualityPrincipalFilter;
import de.intarsys.security.device.common.PrincipalIdPrincipalFilter;
import de.intarsys.security.device.common.PrincipalQuery;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;

public class PrincipalFilterTools {
    public static final String ARG_PRINCIPAL_FILTER = "principalFilter";
    public static final String ARG_PRINCIPAL_ID = "principalId";

    public static IPrincipalFilter createFilter(IArgs args) throws ObjectCreationException {
        String argPrincipalId = ArgTools.getString((IArgs)args, (String)ARG_PRINCIPAL_ID, null);
        if (!StringTools.isEmpty((String)argPrincipalId)) {
            return new PrincipalIdPrincipalFilter(argPrincipalId);
        }
        Object argPrincipalFilter = args.get(ARG_PRINCIPAL_FILTER);
        IPrincipalFilter principalFilter = PrincipalFilterTools.createFilter(argPrincipalFilter);
        if (principalFilter == null) {
            Object sid = args.get("signerIdentifier");
            if (sid instanceof IPrincipal) {
                IPrincipal principal = (IPrincipal)sid;
                principalFilter = new PrincipalEqualityPrincipalFilter(principal);
            } else {
                IX509CertificateFilter certFilter = CertificateFilterTools.createCertificateFilter((Object)sid);
                if (certFilter != null) {
                    principalFilter = new CertificateFilterPrincipalFilter(certFilter);
                }
            }
        }
        return principalFilter;
    }

    public static IPrincipalFilter createFilter(Object object) throws ObjectCreationException {
        if (object == null) {
            return null;
        }
        if (object instanceof IPrincipalFilter) {
            return (IPrincipalFilter)object;
        }
        if (object instanceof IPrincipal) {
            return new PrincipalEqualityPrincipalFilter((IPrincipal)object);
        }
        if (object instanceof String) {
            String expr = (String)object;
            if (StringTools.isEmpty((String)expr)) {
                return null;
            }
            if (expr.indexOf("principal.") >= 0) {
                return PrincipalQuery.create(expr);
            }
            X509CertificateSelectorSerializer parser = new X509CertificateSelectorSerializer();
            try {
                String jsExpr = parser.toJavaScript(expr);
                if (StringTools.isEmpty((String)jsExpr)) {
                    return null;
                }
                return PrincipalQuery.create(jsExpr);
            }
            catch (IOException e) {
                throw new ObjectCreationException("can't create IPrincipalFilter from " + object + "(" + e.getMessage() + ")");
            }
        }
        throw new ObjectCreationException("can't create IPrincipalFilter from " + object);
    }

    private PrincipalFilterTools() {
    }
}

