/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.manage.health.IHealthObject;
import de.intarsys.manage.health.IHealthSupport;
import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.EnumDeviceState;
import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.ICredentialFilter;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.AbstractDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.common.CredentialFilterTools;
import de.intarsys.security.device.common.PACKAGE;
import de.intarsys.security.device.common.PrincipalFilterTools;
import de.intarsys.security.device.health.CommonDeviceHealth;
import de.intarsys.security.device.health.CommonHealthMonitor;
import de.intarsys.security.device.health.IHealthMonitor;
import de.intarsys.security.device.health.IHealthMonitorState;
import de.intarsys.security.device.health.IHealthMonitorTarget;
import de.intarsys.security.device.health.NoopHealthMonitor;
import de.intarsys.security.device.jmx.JmxCommonDevice;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.PrivateKeyTools;
import de.intarsys.tools.activity.IPrompter;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IEnablementSupport;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.KnownReason;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseStateSupport;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.InvocableArgument;
import de.intarsys.tools.reflect.InvocableMethod;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonDevice<P extends CommonDeviceProvider<?>>
implements IDevice,
IElementConfigurable,
IPresentationSupport,
IElementSerializable,
IHealthSupport,
IEnablementSupport,
ILicenseStateSupport,
IHealthMonitorTarget {
    public static final String ARG_DEVICE = "device";
    public static final String ARG_HEALTH_MONITOR = "healthMonitor";
    private static final String ATTR_NOTICES = "notices";
    public static final String PROPERTY_PDF_SIGNATURE_TIME_OFFSET = "pdfSignatureTimeOffset";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ATTR_CREDENTIALS = "credentials";
    public static final String ATTR_PRINCIPALS = "principals";
    public static final String LIC_PRODUCT = "de.intarsys.security.device.common";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean enabled = true;
    private String id;
    private final List<INotice> notices = new CopyOnWriteArrayList<INotice>();
    private String label;
    protected final Object lock = new Object();
    private final AttributeMap attributes = new AttributeMap();
    private final P deviceProvider;
    private final EventDispatcher eventDispatcher = new EventDispatcher((Object)this);
    private final List<IPrincipal> principals = new ArrayList<IPrincipal>();
    private volatile EnumDeviceState state;
    private IHealthMonitor healthMonitor;
    private volatile IHealthMonitorState healthMonitorState;
    private final List<ICredential> credentials = new ArrayList<ICredential>();
    private IElement configuration;
    private Exception exception;
    private volatile String stateReason;
    private NotificationBroadcasterSupport mbean;
    private ObjectName mbeanName;
    private int mbeanNotificationCounter = 0;
    private long pdfSignatureTimeOffset;

    public static PrivateKey getPrivateKey(IX509PublicKeyCertificate certificate, CommonSecurityApplication securityApplication, IPrivateKeyProvider provider, Secret password, IMessage prompt) throws SecurityApplicationException {
        PrivateKey key = null;
        try {
            if (provider != null) {
                if (PrivateKeyTools.isPrivateKeyPasswordProtected((IX509PublicKeyCertificate)certificate)) {
                    if (CryptoTools.isEmpty((Secret)password)) {
                        if (securityApplication.getPasswordProvider() == null) {
                            throw new SecurityApplicationException(Msg.getString("CommonDevice.ErrorPasswordMissing", new Object[0]));
                        }
                        if (securityApplication.getPasswordProvider() instanceof IPrompter) {
                            IMessage title = Msg.getMessage("CommonDevice.passwordProvider.title", new Object[0]);
                            ((IPrompter)securityApplication.getPasswordProvider()).setTitle(title);
                            ((IPrompter)securityApplication.getPasswordProvider()).setMessage(prompt);
                        }
                        password = securityApplication.getPasswordProvider().getPassword();
                        if (securityApplication.getPasswordProvider() instanceof IPrompter) {
                            ((IPrompter)securityApplication.getPasswordProvider()).setMessage(null);
                        }
                        if (CryptoTools.isEmpty((Secret)password)) {
                            throw new AuthenticationCanceled(Msg.getString("CommonDevice.ErrorCanceled", new Object[0]), (Throwable)new KnownReason());
                        }
                    }
                    key = provider.getPrivateKey(certificate, (IPasswordProvider)new ConstantPasswordProvider(password));
                } else {
                    key = provider.getPrivateKey(certificate, (IPasswordProvider)new ConstantPasswordProvider(Secret.EMPTY));
                }
            }
            if (key == null) {
                throw new SecurityApplicationException("didn't receive the private key - check keystore and provided password");
            }
        }
        catch (UnrecoverableKeyException e) {
            throw new AuthenticationFailed(Msg.getString("CommonDevice.ErrorWrongPassword", new Object[0]), (Throwable)new KnownReason());
        }
        catch (IOException e) {
            throw new SecurityApplicationException(Msg.getString("CommonDevice.ErrorIOException", new Object[]{e.getLocalizedMessage()}), e);
        }
        return key;
    }

    protected CommonDevice(P provider, String id) {
        this.deviceProvider = provider;
        this.setId(id);
        this.setStateUnavailable("uninitialized");
    }

    public void addNotice(INotice notice) {
        this.notices.add(notice);
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_NOTICES, null, (Object)notice));
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    protected ISecurityApplication basicCreateApplication(Class<ISecurityApplication> clazz, IArgs args) throws ObjectCreationException {
        IFactory<ISecurityApplication> factory = this.getFactory(clazz);
        if (factory != null) {
            return this.basicCreateApplication(factory, args);
        }
        return null;
    }

    public ISecurityApplication basicCreateApplication(IFactory<? extends ISecurityApplication> factory, IArgs args) throws ObjectCreationException {
        IArgs tmpArgs = args.copy();
        tmpArgs.put(ARG_DEVICE, (Object)this);
        return (ISecurityApplication)factory.createInstance(tmpArgs);
    }

    protected Object basicGetValue(String name) throws FieldException {
        if (PROPERTY_PDF_SIGNATURE_TIME_OFFSET.equals(name)) {
            return this.getPdfSignatureTimeOffset();
        }
        return null;
    }

    protected void basicOnContextClosed() {
    }

    protected void basicOnContextRefreshed() {
    }

    public void clearNotices() {
        this.notices.clear();
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_NOTICES, null, null));
    }

    public void configure(IArgs args) throws Exception {
        this.setId(ArgTools.getString((IArgs)args, (String)"id", (String)this.getId()));
        this.setPdfSignatureTimeOffset(ArgTools.getLongStrict((IArgs)args, (String)PROPERTY_PDF_SIGNATURE_TIME_OFFSET, (long)0L));
        Object healthMonitorArgs = ArgTools.getObject((IArgs)args, (String)ARG_HEALTH_MONITOR, null);
        this.setHealthMonitor(CommonHealthMonitor.from(healthMonitorArgs));
        if (this.getHealthMonitor() == null) {
            this.setHealthMonitor(this.createHealthMonitor(ArgTools.toArgs((Object)healthMonitorArgs)));
        }
    }

    public void configure(IElement element) throws ConfigurationException {
        if (this.logger.isEnabledForLevel(Level.DEBUG)) {
            this.logger.debug("{} configuration \n{}", (Object)this.getLogPrefix(), (Object)element);
        }
        this.configuration = element;
        this.setId(element.attributeValue("id", this.getId()));
        this.setPdfSignatureTimeOffset(ElementTools.getLong((IElement)element, (String)PROPERTY_PDF_SIGNATURE_TIME_OFFSET, (long)0L));
    }

    @Override
    public final Object control(String command, IArgs args) throws ApplicationException {
        if (!this.isEnabled()) {
            throw new SecurityApplicationException(this.getExceptionPrefix() + " disabled");
        }
        return this.controlBasic(command, args);
    }

    protected Object controlBasic(String command, IArgs args) throws ApplicationException {
        switch (command) {
            case "renew": {
                this.renew();
                break;
            }
            default: {
                throw new SecurityApplicationException(this.getExceptionPrefix() + " control '" + command + "' not supported");
            }
        }
        return null;
    }

    @Override
    public final ISecurityApplication createApplication(String id, IArgs args) throws ObjectCreationException {
        try {
            if (!this.isEnabled()) {
                throw new ObjectCreationException(this.getExceptionPrefix() + " disabled");
            }
            if (this.getState().isUnavailable()) {
                throw new ObjectCreationException(this.getExceptionPrefix() + " unavailable");
            }
            if (this.logger.isEnabledForLevel(Level.TRACE)) {
                this.logger.trace("{} create application {}", (Object)this.getLogPrefix(), (Object)id);
            }
            Class clazz = ClassTools.createClass((String)id, ISecurityApplication.class, (ClassLoader)this.getClass().getClassLoader());
            return this.basicCreateApplication(clazz, args);
        }
        catch (ObjectCreationException | RuntimeException e) {
            Notice notice = new Notice(30, false, "application.failed", "error creating application ''{0}'': ''{1}''", new Object[]{id, ExceptionTools.getMessageShort((Throwable)e), e});
            this.sendNotification((INotice)notice);
            throw e;
        }
    }

    protected CommonDeviceHealth createHealth() {
        return new CommonDeviceHealth();
    }

    protected IHealthMonitor createHealthMonitor(IArgs args) {
        NoopHealthMonitor monitor = new NoopHealthMonitor();
        if (args != null) {
            monitor.setArgs(args);
        }
        return monitor;
    }

    protected void createHealthProperties(CommonDeviceHealth health) {
        health.setEnabled(this.isEnabled());
        health.setId(this.getId());
        health.setLicensed(this.getLicenseProduct() == null || LicenseEnvironment.get().getLicenseProductState(this.getLicenseProduct()).isValid());
        health.setState(this.getState().getId());
        health.setStateReason(this.getStateReason());
        health.setType(this.getClass().getName());
    }

    protected String createLabel() {
        return this.getQualifiedId();
    }

    protected void ensureCredentialsAvailable() {
    }

    protected void ensurePrincipalsAvailable() {
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected AttributeMap getAttributes() {
        return this.attributes;
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    public String getDescription() {
        return this.getTip();
    }

    public P getDeviceProvider() {
        return this.deviceProvider;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public Exception getException() {
        return this.exception;
    }

    private String getExceptionPrefix() {
        return "device '" + this.getQualifiedId() + "'";
    }

    protected IFactory<? extends ISecurityApplication> getFactory(Class<ISecurityApplication> clazz) {
        List<IApplicationDescriptor> itDescriptors = ((CommonDeviceProvider)this.getDeviceProvider()).getApplicationDescriptors();
        for (IApplicationDescriptor descriptor : itDescriptors) {
            if (descriptor.getType() != clazz) continue;
            return (IFactory)descriptor;
        }
        return null;
    }

    public IHealthObject getHealth() {
        CommonDeviceHealth health = this.createHealth();
        this.createHealthProperties(health);
        return health;
    }

    public IHealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    @Override
    public IHealthMonitorState getHealthMonitorState() {
        return this.healthMonitorState;
    }

    public String getIconName() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    @InvocableMethod
    public String getLabel() {
        if (this.label == null) {
            return this.createLabel();
        }
        return this.label;
    }

    public LicenseProduct getLicenseProduct() {
        return ((CommonDeviceProvider)this.getDeviceProvider()).getLicenseProduct();
    }

    public EnumLicenseState getLicenseState() {
        return ((CommonDeviceProvider)this.getDeviceProvider()).getLicenseState();
    }

    protected String getLogPrefix() {
        return "device " + this.getQualifiedId();
    }

    protected NotificationBroadcasterSupport getMbean() {
        return this.mbean;
    }

    protected ObjectName getMbeanName() {
        return this.mbeanName;
    }

    protected int getMbeanNotificationCounter() {
        return this.mbeanNotificationCounter;
    }

    public List<INotice> getNotices() {
        return Collections.unmodifiableList(new ArrayList<INotice>(this.notices));
    }

    public long getPdfSignatureTimeOffset() {
        return this.pdfSignatureTimeOffset;
    }

    protected IPreferences getPreferences() {
        IPreferences prefRoot = PreferencesFactory.get().getRoot();
        IPreferences prefDevice = prefRoot.node("de.intarsys.prefs.security.deviceProviders").node(((AbstractDeviceProvider)this.getDeviceProvider()).getId()).node("devices").node(this.getId());
        return prefDevice;
    }

    protected List<IPrincipal> getPrincipals() {
        return this.principals;
    }

    public String getQualifiedId() {
        return this.getId() + "@" + ((AbstractDeviceProvider)this.getDeviceProvider()).getId();
    }

    @Override
    public EnumDeviceState getState() {
        return this.state;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public String getTip() {
        return this.getLabel();
    }

    @InvocableMethod
    public Object getValue(@InvocableArgument(name="name") String name) throws FieldException {
        this.logger.trace("{} getValue({})", (Object)this.getLogPrefix(), (Object)name);
        return this.basicGetValue(name);
    }

    public final void init() {
        try {
            this.mbeanPublish();
        }
        catch (JMException e) {
            this.logger.warn("{} JMX publishing failed", (Object)this, (Object)e);
        }
        if (this.isEnabled()) {
            if (this.getException() == null) {
                try {
                    this.initBasic();
                    this.startHealthMonitor();
                    this.setStateAvailable();
                }
                catch (Exception e) {
                    this.stopHealthMonitor();
                    this.setException(e, "initialization failed");
                }
            }
        } else {
            this.logger.debug("{} is disabled, skip initialization", (Object)this);
            this.setStateUnavailable("disabled");
        }
        this.logState();
        if (this.isEnabled()) {
            this.logConfiguration();
        }
    }

    protected void initBasic() throws Exception {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ICredential> listCredentials(ICredentialFilter filter) {
        this.ensureCredentialsAvailable();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ICredential> tempResult = new ArrayList<ICredential>();
            for (ICredential credential : this.credentials) {
                if (filter != null && !filter.accept(credential)) continue;
                tempResult.add(credential);
            }
            return tempResult.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IPrincipal> listPrincipals(IPrincipalFilter filter) {
        this.ensurePrincipalsAvailable();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IPrincipal> tempResult = new ArrayList<IPrincipal>();
            for (IPrincipal principal : this.principals) {
                if (filter != null && !filter.accept(principal)) continue;
                tempResult.add(principal);
            }
            return tempResult.iterator();
        }
    }

    protected void logConfiguration() {
    }

    protected void logState() {
        this.logger.info("{} is {}", (Object)this, (Object)this.getState());
        if (this.getException() != null) {
            this.logger.info("{} failed with {}", (Object)this, (Object)ExceptionTools.getMessage((Throwable)this.getException()));
        }
    }

    protected NotificationBroadcasterSupport mbeanCreate() {
        return new JmxCommonDevice<CommonDevice>(this);
    }

    protected void mbeanDeclareProperties(Hashtable<String, String> properties) {
        properties.put("type", ARG_DEVICE);
        properties.put("device-provider", ((AbstractDeviceProvider)this.getDeviceProvider()).getId());
        properties.put(ARG_DEVICE, this.getId());
    }

    protected String mbeanGetDomain() {
        return "de.intarsys";
    }

    protected void mbeanPublish() throws JMException {
        this.mbeanUnpublish();
        String domain = this.mbeanGetDomain();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        this.mbeanDeclareProperties(properties);
        this.setMbean(this.mbeanCreate(), new ObjectName(domain, properties));
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        if (server.isRegistered(this.mbeanName)) {
            server.unregisterMBean(this.getMbeanName());
        }
        server.registerMBean(this.getMbean(), this.getMbeanName());
    }

    protected void mbeanSendChangeNotification(String attributeName, String attributeType, Object oldValue, Object newValue) {
        if (this.getMbean() == null) {
            return;
        }
        AttributeChangeNotification notification = new AttributeChangeNotification(this.getMbeanName(), this.mbeanNotificationCounter++, System.currentTimeMillis(), attributeName + " changed (" + newValue + ")", attributeName, attributeType, oldValue, newValue);
        this.getMbean().sendNotification(notification);
    }

    protected void mbeanSendNotification(String type, String message, int severity) {
        if (this.getMbean() == null) {
            return;
        }
        Notification notification = new Notification(type, this.getMbeanName(), this.mbeanNotificationCounter++, System.currentTimeMillis(), message);
        HashMap<String, Integer> userData = new HashMap<String, Integer>();
        userData.put("severity", severity);
        notification.setUserData(userData);
        this.getMbean().sendNotification(notification);
    }

    protected void mbeanUnpublish() throws JMException {
        if (this.getMbeanName() == null) {
            return;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.unregisterMBean(this.getMbeanName());
        this.setMbean(null, null);
    }

    public final void onContextClosed() {
        if (!this.isEnabled()) {
            return;
        }
        this.basicOnContextClosed();
    }

    public void onContextRefreshed() {
        if (!this.isEnabled()) {
            return;
        }
        this.basicOnContextRefreshed();
    }

    @Override
    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCredential(ICredential credential) {
        Object object = this.lock;
        synchronized (object) {
            this.credentials.add(credential);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_CREDENTIALS, null, (Object)credential));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPrincipal(IPrincipal principal) {
        Object object = this.lock;
        synchronized (object) {
            this.principals.add(principal);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_PRINCIPALS, null, (Object)principal));
    }

    public Object removeAttribute(Object key) {
        Object oldValue = this.attributes.removeAttribute(key);
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, key, oldValue, null));
        return oldValue;
    }

    public boolean removeNotice(INotice notice) {
        if (this.notices.remove(notice)) {
            this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_NOTICES, (Object)notice, null));
            return true;
        }
        return false;
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    public void renew() {
    }

    public void sendNotification(INotice notice) {
        this.mbeanSendNotification(notice.getCode(), notice.getString(), notice.getSeverity());
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("factory", this.getDeviceProvider().getClass().getName());
        if (this.id != null) {
            element.setAttributeValue("id", this.getId());
        }
    }

    public Object setAttribute(Object key, Object value) {
        Object oldValue = this.attributes.setAttribute(key, value);
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, key, oldValue, value));
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCredentials(List<ICredential> pCredentials) {
        Object object = this.lock;
        synchronized (object) {
            if (this.credentials.equals(pCredentials)) {
                return;
            }
            this.credentials.clear();
            this.credentials.addAll(pCredentials);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_CREDENTIALS, null, null));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void setException(Exception exception, String context) {
        Exception oldException = this.exception;
        this.exception = exception;
        if (exception == null) {
            if (oldException != null) {
                this.logger.warn("{} {}", (Object)this, (Object)context);
                this.setStateAvailable();
            }
        } else if (oldException == null) {
            String msg = "{} {} - {}";
            String exMessage = ExceptionTools.getMessage((Throwable)exception);
            if (this.logger.isEnabledForLevel(Level.DEBUG)) {
                this.logger.warn(msg, new Object[]{this, context, exMessage, exception});
            } else {
                this.logger.warn(msg, new Object[]{this, context, exMessage});
            }
            this.setStateUnavailable(exMessage);
        }
    }

    public void setHealthMonitor(IHealthMonitor healthMonitor) {
        this.healthMonitor = healthMonitor;
    }

    @Override
    public void setHealthMonitorState(IHealthMonitorState monitorState) {
        this.healthMonitorState = monitorState;
        if (monitorState != null && monitorState.isFailed()) {
            this.setException(monitorState.getException(), "health check failed");
        } else {
            this.setException(null, "health check success");
        }
    }

    public void setId(String id) {
        DeviceTools.validateId(id);
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    protected void setMbean(NotificationBroadcasterSupport mbean, ObjectName mbeanName) {
        this.mbean = mbean;
        this.mbeanName = mbeanName;
    }

    protected void setMbeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    protected void setMbeanNotificationCounter(int mbeanNotificationCounter) {
        this.mbeanNotificationCounter = mbeanNotificationCounter;
    }

    public void setPdfSignatureTimeOffset(long pdfSignatureTimeOffset) {
        this.pdfSignatureTimeOffset = pdfSignatureTimeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrincipals(List<IPrincipal> pPrincipals) {
        Object object = this.lock;
        synchronized (object) {
            if (this.principals.equals(pPrincipals)) {
                return;
            }
            this.principals.clear();
            this.principals.addAll(pPrincipals);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_PRINCIPALS, null, null));
    }

    protected void setStateAvailable() {
        this.state = EnumDeviceState.AVAILABLE;
        this.stateReason = null;
    }

    protected void setStateUnavailable(String reason) {
        this.state = EnumDeviceState.UNAVAILABLE;
        this.stateReason = reason;
    }

    public Object setValue(String name, Object value) throws FieldException {
        return null;
    }

    protected void startHealthMonitor() {
        if (this.getHealthMonitor() != null) {
            this.getHealthMonitor().start(this);
        }
    }

    protected void stopHealthMonitor() {
        if (this.getHealthMonitor() != null) {
            this.getHealthMonitor().stop();
            this.setHealthMonitor(null);
        }
    }

    public String toString() {
        return ClassTools.getUnqualifiedName(this.getClass()) + " '" + this.getQualifiedId() + "'";
    }

    protected void triggerEvent(Event event) {
        this.eventDispatcher.triggerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCredential(ICredential credential) {
        Object object = this.lock;
        synchronized (object) {
            this.credentials.remove(credential);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_CREDENTIALS, (Object)credential, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPrincipal(IPrincipal principal) {
        Object object = this.lock;
        synchronized (object) {
            this.principals.remove(principal);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)ATTR_PRINCIPALS, (Object)principal, null));
    }

    public static class PrincipalFilterConverter
    implements IConverter<Object, IPrincipalFilter> {
        public IPrincipalFilter convert(Object source) throws ConversionException {
            try {
                return PrincipalFilterTools.createFilter(source);
            }
            catch (ObjectCreationException e) {
                throw new ConversionException((Throwable)e);
            }
        }

        public Class<?> getSourceType() {
            return Object.class;
        }

        public Class<?> getTargetType() {
            return IPrincipalFilter.class;
        }
    }

    public static class CredentialFilterConverter
    implements IConverter<Object, ICredentialFilter> {
        public ICredentialFilter convert(Object source) throws ConversionException {
            try {
                return CredentialFilterTools.createFilter(source);
            }
            catch (ObjectCreationException e) {
                throw new ConversionException((Throwable)e);
            }
        }

        public Class<?> getSourceType() {
            return Object.class;
        }

        public Class<?> getTargetType() {
            return ICredentialFilter.class;
        }
    }
}

