/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.info.X500SimpleName;
import de.intarsys.security.device.IPrincipalSupport;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.ISignatureDataList;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.expression.ConstantResolver;
import de.intarsys.tools.expression.ResolveProperty;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;

public interface ISigner
extends ISecurityApplication,
IPrincipalSupport {
    public static final String ARG_BATCH = "batch";
    public static final String ARG_DIGEST_SIGNER = "digestSigner";
    public static final String ARG_SIGNER_IDENTIFIER = "signerIdentifier";
    public static final String ARG_SIGNER_PASSWORD = "signerPassword";
    public static final String ARG_INCLUDE_CERTIFICATE_CHAIN = "includeCertificateChain";
    public static final String ARG_INCLUDE_CERTIFICATE_PATH = "includeCertificatePath";
    public static final String ARG_SUPPORTED_HASH_ALGORITHMS = "supportedHashAlgorithms";
    public static final String ARG_PREFERRED_HASH_ALGORITHM = "preferredHashAlgorithm";
    public static final String ARG_HASH_ALGORITHM = "hashAlgorithm";
    public static final String ARG_ALGORITHM_PARAMETER_SPEC = "algorithmParameterSpec";
    public static final String ARG_SIGNATURE_EVIDENCE = "signatureEvidence";
    public static final String ARG_PROCESSING_MESSAGE = "processingMessage";
    public static final String ARG_SIGNATURE_LABEL = "signatureLabel";
    public static final Object ATTR_CERTIFICATE = new Attribute("certificate");

    @Deprecated
    public void buildCertificatePath();

    public AlgorithmParameterSpec getAlgorithmParameterSpec();

    public int getApproximatedContainerSize();

    public IX509PublicKeyCertificate[] getCertificatePath();

    default public IX509PublicKeyCertificate getCertificate() {
        IX509PublicKeyCertificate[] certificatePath = this.getCertificatePath();
        return certificatePath == null || certificatePath.length == 0 ? null : certificatePath[0];
    }

    public String getEncryptionAlgorithmName();

    public String getHashAlgorithmName();

    public String getPreferredHashAlgorithmName();

    public SignatureFormat getSignatureFormat();

    public Collection<String> getSupportedHashAlgorithmNames();

    public boolean isBasic();

    @ResolveProperty(property="issuer")
    default public Object resolveIssuer() {
        IX509PublicKeyCertificate certificate = this.getCertificate();
        return certificate == null ? new ConstantResolver((Object)"") : new X500SimpleName(certificate.getIssuerX500Principal());
    }

    @ResolveProperty(property="subject")
    default public Object resolveSubject() {
        IX509PublicKeyCertificate certificate = this.getCertificate();
        return certificate == null ? new ConstantResolver((Object)"") : new X500SimpleName(certificate.getSubjectX500Principal());
    }

    public void setHashAlgorithmName(String var1) throws SecurityApplicationException;

    public void setSignatureFormat(SignatureFormat var1);

    public void setSignatureOptions(SignatureOptions var1);

    public IConversation<ISignatureData> sign(IToBeSignedData var1);

    public IConversation<Void> signAbort();

    public IConversation<Void> signBegin();

    public IConversation<ISignatureDataList> signCommit();

    public IConversation<Void> signPrepare();
}

