/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.crypt.symmetric.common;

import de.intarsys.security.app.crypt.symmetric.common.CommonCryptHandler;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public abstract class CommonParameterizedCryptHandler
extends CommonCryptHandler {
    protected CommonParameterizedCryptHandler(CommonDevice device) throws ObjectCreationException {
        super(device);
    }

    @Override
    protected AlgorithmParameters decodeAlgorithmParameters(byte[] encoded) throws GeneralSecurityException, IOException {
        AlgorithmParameters parameters = AlgorithmParameters.getInstance(this.getParameterAlgorithm(), this.getProvider());
        parameters.init(encoded, "ASN.1");
        return parameters;
    }

    @Override
    protected byte[] encodeAlgorithmParameters(AlgorithmParameters parameters) throws GeneralSecurityException, IOException {
        return parameters.getEncoded("ASN.1");
    }

    @Override
    protected AlgorithmParameters generateAlgorithmParameters(Cipher cipher) throws GeneralSecurityException {
        AlgorithmParameterGenerator paramGenerator = AlgorithmParameterGenerator.getInstance(this.getParameterAlgorithm(), this.getProvider());
        paramGenerator.init(cipher.getBlockSize());
        AlgorithmParameters parameters = paramGenerator.generateParameters();
        return parameters;
    }

    protected abstract String getParameterAlgorithm();
}

