/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.validator.rest.to.response;

import ch.admin.suis.validator.rest.to.ValidStatus;
import ch.admin.suis.validator.rest.to.ValidationType;
import ch.admin.suis.validator.rest.to.response.ReportCertificate;
import ch.admin.suis.validator.rest.to.response.ReportMandator;
import ch.admin.suis.validator.rest.to.response.ReportRevocation;
import ch.admin.suis.validator.rest.to.response.ReportTimestamp;
import ch.admin.suis.validator.rest.to.response.ShortReport;
import java.util.List;

public class SignatureReport {
    private ReportCertificate certificateDetails;
    private ReportMandator mandatorDetails;
    private List<ShortReport> reports;
    private ReportRevocation revocationDetails;
    private String signatureName;
    private ReportTimestamp timestampDetails;

    public ReportCertificate getCertificateDetails() {
        return this.certificateDetails;
    }

    public ReportMandator getMandatorDetails() {
        return this.mandatorDetails;
    }

    public List<ShortReport> getReports() {
        return this.reports;
    }

    public ReportRevocation getRevocationDetails() {
        return this.revocationDetails;
    }

    public String getSignatureName() {
        return this.signatureName;
    }

    public ReportTimestamp getTimestampDetails() {
        return this.timestampDetails;
    }

    public ValidStatus isValid() {
        ValidStatus state = ValidStatus.VALID;
        for (ShortReport rep : this.reports) {
            if (rep.getValid() == ValidStatus.VALID || state == ValidStatus.INVALID) continue;
            state = rep.getValid();
        }
        return state;
    }

    public ValidStatus isValidCert() {
        for (ShortReport rep : this.reports) {
            if (rep.getType() != ValidationType.CERTIFICATE) continue;
            return rep.getValid();
        }
        return ValidStatus.INVALID;
    }

    public ValidStatus isValidMandant() {
        for (ShortReport rep : this.reports) {
            if (rep.getType() != ValidationType.MANDATOR) continue;
            return rep.getValid();
        }
        return ValidStatus.INVALID;
    }

    public ValidStatus isValidRevoc() {
        for (ShortReport rep : this.reports) {
            if (rep.getType() != ValidationType.REVOCATION) continue;
            return rep.getValid();
        }
        return ValidStatus.INVALID;
    }

    public ValidStatus isValidSig() {
        for (ShortReport rep : this.reports) {
            if (rep.getType() != ValidationType.INTEGRITY) continue;
            return rep.getValid();
        }
        return ValidStatus.INVALID;
    }

    public ValidStatus isValidTimestamp() {
        for (ShortReport rep : this.reports) {
            if (rep.getType() != ValidationType.TIMESTAMP) continue;
            return rep.getValid();
        }
        return ValidStatus.INVALID;
    }

    public void setCertificateDetails(ReportCertificate certificateDetails) {
        this.certificateDetails = certificateDetails;
    }

    public void setMandatorDetails(ReportMandator mandatorDetails) {
        this.mandatorDetails = mandatorDetails;
    }

    public void setReports(List<ShortReport> reports) {
        this.reports = reports;
    }

    public void setRevocationDetails(ReportRevocation revocationDetails) {
        this.revocationDetails = revocationDetails;
    }

    public void setSignatureName(String signatureName) {
        this.signatureName = signatureName;
    }

    public void setTimestampDetails(ReportTimestamp timestampDetails) {
        this.timestampDetails = timestampDetails;
    }
}

