/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.authenticate;

import de.intarsys.aaa.authenticate.api.ICredentialScope;
import de.intarsys.aaa.authenticate.api.ICredentialSpec;
import de.intarsys.aaa.authenticate.impl.NTCredentialSpec;
import de.intarsys.aaa.authenticate.impl.UserPasswordCredentialSpec;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.StringTools;

public class HttpCredentialScope
implements ICredentialScope {
    private final String host;
    private final int port;
    private final String realm;
    private final String scheme;

    public HttpCredentialScope(String host, int port) {
        this(host, port, null, null);
    }

    public HttpCredentialScope(String host, int port, String realm, String scheme) {
        this.host = host == null ? null : host.toLowerCase();
        this.port = port < 0 ? -1 : port;
        this.realm = realm == null ? null : realm;
        this.scheme = scheme == null ? null : scheme.toUpperCase();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpCredentialScope)) {
            return false;
        }
        return LangTools.equals((Object)this.host, (Object)((HttpCredentialScope)obj).host) && LangTools.equals((Object)this.realm, (Object)((HttpCredentialScope)obj).realm) && LangTools.equals((Object)this.scheme, (Object)((HttpCredentialScope)obj).scheme) && this.port == ((HttpCredentialScope)obj).port;
    }

    public ICredentialSpec getCredentialSpec() {
        if ("ntlm".equalsIgnoreCase(this.scheme)) {
            return new NTCredentialSpec();
        }
        if ("kerberos".equalsIgnoreCase(this.scheme)) {
            return new UserPasswordCredentialSpec();
        }
        if ("negotiate".equalsIgnoreCase(this.scheme)) {
            return new UserPasswordCredentialSpec();
        }
        if ("basic".equalsIgnoreCase(this.scheme)) {
            return new UserPasswordCredentialSpec();
        }
        if ("digest".equalsIgnoreCase(this.scheme)) {
            return new UserPasswordCredentialSpec();
        }
        return new UserPasswordCredentialSpec();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrompt() {
        if (!StringTools.isEmpty((String)this.realm)) {
            return this.realm;
        }
        return this.host;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int hashCode() {
        int result = 0;
        if (this.host != null) {
            result = this.host.hashCode();
        }
        return result;
    }

    public int match(ICredentialScope other) {
        if (!(other instanceof HttpCredentialScope)) {
            return -1;
        }
        HttpCredentialScope that = (HttpCredentialScope)other;
        int factor = 0;
        if (LangTools.equals((Object)this.scheme, (Object)that.scheme)) {
            ++factor;
        } else if (this.scheme != null && that.scheme != null) {
            return -1;
        }
        if (LangTools.equals((Object)this.realm, (Object)that.realm)) {
            factor += 2;
        } else if (this.realm != null && that.realm != null) {
            return -1;
        }
        if (this.port == that.port) {
            factor += 4;
        } else if (this.port != -1 && that.port != -1) {
            return -1;
        }
        if (LangTools.equals((Object)this.host, (Object)that.host)) {
            factor += 8;
        } else if (this.host != null && that.host != null) {
            return -1;
        }
        return factor;
    }

    public String toString() {
        return "HttpCredentialScope [host=" + this.host + ", port=" + this.port + ", realm=" + this.realm + ", scheme=" + this.scheme + "]";
    }
}

