/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.kdf;

import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.IKeyDerivationFunction;
import de.intarsys.tools.crypto.kdf.Hkdf;
import jakarta.annotation.PostConstruct;
import java.io.IOException;

public class HashedKeyDerivationFunction
implements IKeyDerivationFunction {
    private static final int NUM_BYTES = 32;
    private Hkdf hkdf;
    private IByteStreamProvider saltProvider;
    private IByteProvider keyProvider;

    @Override
    public byte[] derive(byte[] info, int length) {
        return this.hkdf.expand(info, length);
    }

    public IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    protected byte[] getSalt() throws IOException {
        if (this.getSaltProvider() == null) {
            return null;
        }
        return this.getSaltProvider().getBytes(32);
    }

    public IByteStreamProvider getSaltProvider() {
        return this.saltProvider;
    }

    @PostConstruct
    public void init() {
        try {
            IByteProvider keyProvider = this.getKeyProvider();
            if (keyProvider == null) {
                throw new IllegalArgumentException("key provider - key loader required");
            }
            byte[] ikm = keyProvider.getBytes();
            if (ikm == null) {
                throw new IllegalArgumentException("key provider - master key required");
            }
            this.hkdf = new Hkdf(this.getSalt(), ikm);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating master key", e);
        }
    }

    public void setKeyProvider(IByteProvider keyLoader) {
        this.keyProvider = keyLoader;
    }

    public void setSaltProvider(IByteStreamProvider saltProvider) {
        this.saltProvider = saltProvider;
    }
}

