/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation.commonpki;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.standard.validation.commonpki.ISignatureAlgorithmInfo;
import de.intarsys.security.standard.validation.commonpki.RSASignatureAlgorithmInfo;
import de.intarsys.tools.component.SingletonClass;
import java.security.PublicKey;

@SingletonClass
public class SignatureAlgorithmInfoFactory {
    private static final SignatureAlgorithmInfoFactory ACTIVE = new SignatureAlgorithmInfoFactory();

    public static SignatureAlgorithmInfoFactory get() {
        return ACTIVE;
    }

    protected SignatureAlgorithmInfoFactory() {
    }

    public ISignatureAlgorithmInfo createInfo(IX509PublicKeyCertificate certificate) {
        return this.createInfo(certificate.getPublicKey());
    }

    public ISignatureAlgorithmInfo createInfo(PublicKey publicKey) {
        if (publicKey.getAlgorithm().indexOf("RSA") >= 0) {
            return new RSASignatureAlgorithmInfo(publicKey);
        }
        return null;
    }
}

