/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.privatekey;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import java.security.PrivateKey;
import java.security.PublicKey;

public class KeyCertificatePair {
    private final PrivateKey privateKey;
    private final IX509PublicKeyCertificate certificate;

    public KeyCertificatePair(IX509PublicKeyCertificate certificate) {
        this.certificate = certificate;
        this.privateKey = null;
    }

    public KeyCertificatePair(PrivateKey privateKey, IX509PublicKeyCertificate certificate) {
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public IX509PublicKeyCertificate[] getCertificateChain() {
        return new IX509PublicKeyCertificate[]{this.getCertificate()};
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }
}

