/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class X509ExtensionCRLDistributionPoints
extends CommonX509Extension {
    public static final String OID = "2.5.29.31";
    private List<String> urls = new ArrayList<String>();

    public static X509ExtensionCRLDistributionPoints create(byte[] encoded) throws IOException {
        X509ExtensionCRLDistributionPoints result = new X509ExtensionCRLDistributionPoints();
        CRLDistPoint crlDistPoints = CRLDistPoint.getInstance((Object)ASN1Tools.create((byte[])encoded));
        DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
        for (int i = 0; i < distPoints.length; ++i) {
            DistributionPoint crlDistPoint = distPoints[i];
            DistributionPointName dp_name = crlDistPoint.getDistributionPoint();
            if (dp_name.getType() != 0) continue;
            GeneralName[] generalNames = GeneralNames.getInstance((Object)dp_name.getName()).getNames();
            for (int j = 0; j < generalNames.length; ++j) {
                if (generalNames[j].getTagNo() != 6) continue;
                String url = ((DERIA5String)generalNames[j].getName()).getString();
                result.addUrl(url);
            }
        }
        return result;
    }

    public X509ExtensionCRLDistributionPoints() {
        this.setCritical(false);
    }

    public void addUrl(String url) {
        this.urls.add(url);
    }

    protected DistributionPoint createDistributionPoint(String url) {
        GeneralName name = new GeneralName(6, url);
        GeneralNames names = new GeneralNames(name);
        DistributionPointName distributionPoint = new DistributionPointName(names);
        DistributionPoint point = new DistributionPoint(distributionPoint, null, null);
        return point;
    }

    @Override
    public String getOid() {
        return OID;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    @Override
    public byte[] getValue() throws IOException {
        ArrayList<DistributionPoint> distributionPoints = new ArrayList<DistributionPoint>();
        for (String url : this.getUrls()) {
            distributionPoints.add(this.createDistributionPoint(url));
        }
        CRLDistPoint crlDistPoint = new CRLDistPoint(distributionPoints.toArray(new DistributionPoint[distributionPoints.size()]));
        return crlDistPoint.getEncoded("DER");
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }
}

