/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;

public class IssuingDistributionPointHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("IssuingDistributionPointHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.28";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive derIDP = CertificateTools.getExtensionValue(object, "2.5.29.28");
        IssuingDistributionPoint idp = IssuingDistributionPoint.getInstance((Object)derIDP);
        if (idp == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Indirect CRL: ").append(idp.isIndirectCRL()).append(StringTools.LS);
        sb.append("Only CA certs: ").append(idp.onlyContainsCACerts()).append(StringTools.LS);
        sb.append("Only user certs: ").append(idp.onlyContainsUserCerts()).append(StringTools.LS);
        sb.append("Only attribute certs: ").append(idp.onlyContainsAttributeCerts()).append(StringTools.LS);
        return sb.toString();
    }
}

