/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.encoding.AbstractEncoding;
import de.intarsys.security.encoding.IEncoding;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Random;

public class PSSEncoding
extends AbstractEncoding {
    public static final String NAME = "EMSA-PSS";
    private static byte[] ZEROES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private SecureRandom random = CryptoTools.createSecureRandom();
    private int saltLength = -1;
    private int trailerField = 1;
    private byte[] salt;
    private IDigester digester;
    private int digestLength;

    public static IEncoding createFrom(AlgorithmParameterSpec paramSpec) throws GeneralSecurityException {
        if (paramSpec instanceof PSSParameterSpec) {
            PSSParameterSpec pssParamSpec = (PSSParameterSpec)paramSpec;
            PSSEncoding result = new PSSEncoding();
            String hashAlgoName = pssParamSpec.getDigestAlgorithm();
            result.setDigester(DigestTools.createDigester((String)DigestAlgorithm.lookupAlgorithmName(hashAlgoName)));
            result.setSaltLength(result.getDigestLength());
            return result;
        }
        throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec " + paramSpec + " not supported");
    }

    public static PSSParameterSpec createPSSParameterSpec(DigestAlgorithm digestAlgorithm) {
        String algorithmName = digestAlgorithm.getName();
        int saltLength = digestAlgorithm.getSize();
        return new PSSParameterSpec(algorithmName, "MGF1", new MGF1ParameterSpec(algorithmName), saltLength, 1);
    }

    public static PSSParameterSpec createPSSParameterSpec(String hashAlgorithmName) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(hashAlgorithmName);
        return PSSEncoding.createPSSParameterSpec(algorithm);
    }

    @Override
    protected byte[] basicDecode(byte[] bytes) throws IOException {
        return bytes;
    }

    @Override
    protected byte[] basicEncode(byte[] mHashBytes) throws IOException {
        if (this.isDerEncoded()) {
            IDigest digest = DigestTools.decode((byte[])mHashBytes);
            mHashBytes = digest.getBytes();
        }
        if (this.getDigestLength() != mHashBytes.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (this.getIntendedLengthBits() < 8 * this.getDigestLength() + 8 * this.getSaltLength() + 9) {
            throw new IllegalArgumentException("encoding error");
        }
        byte[] saltBytes = this.getSalt();
        this.getDigester().reset();
        this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(ZEROES));
        this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(mHashBytes));
        this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(saltBytes, 0, this.getSaltLength()));
        IDigest digest = this.getDigester().digestFinal();
        byte[] digestBytes = digest.getBytes();
        byte[] dbBytes = new byte[this.getIntendedLengthBytes() - this.getDigestLength() - 1];
        dbBytes[dbBytes.length - this.getSaltLength() - 1] = 1;
        System.arraycopy(saltBytes, 0, dbBytes, dbBytes.length - this.getSaltLength(), this.getSaltLength());
        byte[] dbMask = this.maskGeneratorFunction(digestBytes, dbBytes.length);
        for (int i = 0; i != dbMask.length; ++i) {
            dbBytes[i] = (byte)(dbBytes[i] ^ dbMask[i]);
        }
        dbBytes[0] = (byte)(dbBytes[0] & (byte)(255 >>> 8 * this.getIntendedLengthBytes() - this.getIntendedLengthBits()));
        byte[] result = new byte[this.getIntendedLengthBytes()];
        System.arraycopy(dbBytes, 0, result, 0, dbBytes.length);
        System.arraycopy(digestBytes, 0, result, dbBytes.length, this.getDigestLength());
        result[result.length - 1] = this.getTrailerByte();
        return result;
    }

    @Override
    protected boolean basicMatch(byte[] mHashBytes, byte[] encoded) throws IOException {
        int i;
        int zeroes;
        if (this.isDerEncoded()) {
            IDigest digest = DigestTools.decode((byte[])mHashBytes);
            mHashBytes = digest.getBytes();
        }
        if ((encoded[encoded.length - 1] & 0xFF) != 188) {
            throw new IOException("invalid encoding, 0xbc trailer expected");
        }
        int emBytes = encoded.length;
        byte firstByte = encoded[0];
        for (zeroes = 0; (firstByte & (byte)(128 >>> zeroes)) == 0 && zeroes < 7; ++zeroes) {
        }
        byte[] dbBytes = new byte[emBytes - this.getDigestLength() - 1];
        byte[] hBytes = new byte[this.getDigestLength()];
        System.arraycopy(encoded, 0, dbBytes, 0, dbBytes.length);
        System.arraycopy(encoded, dbBytes.length, hBytes, 0, hBytes.length);
        byte[] dbMask = this.maskGeneratorFunction(hBytes, dbBytes.length);
        for (i = 0; i < dbBytes.length; ++i) {
            dbBytes[i] = (byte)(dbBytes[i] ^ dbMask[i]);
        }
        dbBytes[0] = (byte)(dbBytes[0] & 255 >>> zeroes);
        for (i = 0; i < emBytes - this.getDigestLength() - this.getSaltLength() - 2; ++i) {
            if (dbBytes[i] == 0) continue;
            throw new IOException("invalid encoding, 0x00 expected");
        }
        if (dbBytes[emBytes - this.getDigestLength() - this.getSaltLength() - 2] != 1) {
            throw new IOException("invalid encoding, 0x01 expected");
        }
        byte[] salt = new byte[this.getSaltLength()];
        System.arraycopy(dbBytes, dbBytes.length - this.getSaltLength(), salt, 0, this.getSaltLength());
        this.getDigester().reset();
        this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(ZEROES));
        this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(mHashBytes));
        this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(salt));
        byte[] h0Bytes = this.getDigester().digestFinal().getBytes();
        return Arrays.equals(hBytes, h0Bytes);
    }

    public IDigester getDigester() {
        return this.digester;
    }

    protected int getDigestLength() {
        return this.digestLength;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected SecureRandom getRandom() {
        return this.random;
    }

    protected byte[] getSalt() {
        if (this.salt == null) {
            SecureRandom tempRandom = this.getRandom();
            if (tempRandom == null) {
                tempRandom = CryptoTools.createSecureRandom();
            }
            byte[] saltBytes = new byte[this.getSaltLength()];
            if (this.getSaltLength() != 0) {
                ((Random)tempRandom).nextBytes(saltBytes);
            }
            return saltBytes;
        }
        return this.salt;
    }

    public int getSaltLength() {
        if (this.saltLength == -1) {
            return this.getDigestLength();
        }
        return this.saltLength;
    }

    protected byte getTrailerByte() {
        return -68;
    }

    protected int getTrailerField() {
        return this.trailerField;
    }

    protected byte[] maskGeneratorFunction(byte[] Z, int length) throws IOException {
        byte[] mask = new byte[length];
        byte[] C = new byte[4];
        this.getDigester().reset();
        int limit = (length + this.getDigestLength() - 1) / this.getDigestLength();
        int index = 0;
        for (int i = 0; i < limit; ++i) {
            this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(Z));
            C = ByteArrayTools.toBytesBigEndian((int)i, (int)4);
            this.getDigester().digestUpdate((InputStream)new ByteArrayInputStream(C));
            IDigest digest = this.getDigester().digestFinal();
            int tempLength = this.getDigestLength();
            if (tempLength > length - index) {
                tempLength = length - index;
            }
            System.arraycopy(digest.getBytes(), 0, mask, index, tempLength);
            index += tempLength;
        }
        return mask;
    }

    public void setDigester(IDigester digester) {
        this.digester = digester;
        this.digestLength = digester.getDigestLength();
    }

    protected void setRandom(SecureRandom random) {
        this.random = random;
    }

    protected void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public void setSaltLength(int saltLength) {
        this.saltLength = saltLength;
    }

    protected void setTrailerField(int trailerField) {
        this.trailerField = trailerField;
    }
}

