/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.crl.common.ICRLCache;
import de.intarsys.security.crl.common.X509CRLSelector;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IOriginProvider;
import de.intarsys.security.validation.Origin;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.servicelocator.ServiceLocator;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.X509Extensions;

@SingletonProvider
public class CRLCache
implements ICRLCache,
IOriginProvider<IX509CRL> {
    private static final Comparator<IX509CRL> crlComparator = new Comparator<IX509CRL>(){

        @Override
        public int compare(IX509CRL crl1, IX509CRL crl2) {
            try {
                ASN1Integer crlNumber1 = ASN1Integer.getInstance((Object)CertificateTools.getExtensionValue(crl1, X509Extensions.CRLNumber.getId()));
                ASN1Integer crlNumber2 = ASN1Integer.getInstance((Object)CertificateTools.getExtensionValue(crl2, X509Extensions.CRLNumber.getId()));
                if (crlNumber1 != null && crlNumber2 != null) {
                    return crlNumber1.getValue().compareTo(crlNumber2.getValue());
                }
            }
            catch (IOException crlNumber1) {
                // empty catch block
            }
            Date nextUpdate1 = crl1.getNextUpdate();
            Date nextUpdate2 = crl2.getNextUpdate();
            if (nextUpdate1 == null) {
                if (nextUpdate2 != null) {
                    return -1;
                }
            } else {
                if (nextUpdate2 == null) {
                    return 1;
                }
                return nextUpdate1.compareTo(nextUpdate2);
            }
            Date thisUpdate1 = crl1.getThisUpdate();
            Date thisUpdate2 = crl2.getThisUpdate();
            if (thisUpdate1 == null) {
                if (thisUpdate2 != null) {
                    return -1;
                }
            } else {
                if (thisUpdate2 == null) {
                    return 1;
                }
                return thisUpdate1.compareTo(thisUpdate2);
            }
            return 0;
        }
    };
    private SoftReference<Set<IX509CRL>> cache;

    public static ICRLCache get() {
        return (ICRLCache)ServiceLocator.get().get(ICRLCache.class);
    }

    @Override
    public void addCRL(IX509CRL crl) {
        X509CRLSelector selector = new X509CRLSelector();
        selector.addIssuer(crl.getIssuerX500Principal());
        Collection<IX509CRL> containedCrls = this.getCRLs(selector);
        ArrayList<IX509CRL> list = new ArrayList<IX509CRL>(containedCrls);
        IX509CRL latest = list.stream().reduce(crl, BinaryOperator.maxBy(crlComparator));
        this.basicAddCRL(latest);
        list.remove(latest);
        this.removeCRLs(list);
    }

    public void addCRLs(Collection<IX509CRL> crls) {
        for (IX509CRL crl : crls) {
            this.addCRL(crl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicAddCRL(IX509CRL crl) {
        SoftReference<Set<IX509CRL>> softReference = this.getCache();
        synchronized (softReference) {
            this.getCache().get().add(crl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stream<IX509CRL> basicGetCRLs(IX509CRLSelector selector, String url) {
        SoftReference<Set<IX509CRL>> softReference = this.getCache();
        synchronized (softReference) {
            return CrlTools.selectCRLs(selector, this.getCache().get().stream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        SoftReference<Set<IX509CRL>> softReference = this.getCache();
        synchronized (softReference) {
            this.getCache().get().clear();
        }
    }

    protected SoftReference<Set<IX509CRL>> getCache() {
        if (this.cache == null || this.cache.get() == null) {
            this.cache = new SoftReference(new HashSet());
        }
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IX509CRL> getCRLs() {
        SoftReference<Set<IX509CRL>> softReference = this.getCache();
        synchronized (softReference) {
            return new HashSet<IX509CRL>((Collection)this.getCache().get());
        }
    }

    public Collection<IX509CRL> getCRLs(IX509CRLSelector selector) {
        return this.basicGetCRLs(selector, null).collect(Collectors.toList());
    }

    @Override
    public IOrigin getOrigin(IX509CRL element) {
        return Origin.cache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<IX509CRL> lookupCRLs(IX509CRLSelector selector, String url) {
        SoftReference<Set<IX509CRL>> softReference = this.getCache();
        synchronized (softReference) {
            return this.basicGetCRLs(selector, url).peek(CrlTools.attachProvider(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCRL(IX509CRL crl) {
        SoftReference<Set<IX509CRL>> softReference = this.getCache();
        synchronized (softReference) {
            this.getCache().get().remove(crl);
        }
    }

    public void removeCRLs(Collection<IX509CRL> crls) {
        for (IX509CRL crl : crls) {
            this.removeCRL(crl);
        }
    }
}

