/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.ICRL;
import de.intarsys.security.crl.IRemoteAccessInfo;
import de.intarsys.security.crl.IRemoteAccessor;
import de.intarsys.security.crl.IUpdateResult;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.crl.common.UpdateResult;
import de.intarsys.security.crl.remote.RemoteAccessInfoHTTP;
import de.intarsys.security.crl.remote.RemoteAccessInfoLDAP;
import de.intarsys.security.crl.remote.RemoteAccessorRegistry;
import de.intarsys.security.tools.X500NameTools;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.infoset.DocumentTools;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRL
implements ICRL {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ELEM_CRL = "crl";
    private static final String ELEM_REMOTEACCESS = "remoteAccess";
    private static final Logger Log = LoggerFactory.getLogger(CRL.class);
    private static final String NAME_CONFIG_FILE = "crl.xml";
    private List<IRemoteAccessInfo> accessInfos = new ArrayList<IRemoteAccessInfo>();
    private SoftReference<IX509CRL> crlImpl;
    private ILocator crlLocator;
    private X500Principal[] issuers;
    private ILocator locator;
    private String name;

    public static CRL createFromLocator(ILocator locator) throws IOException {
        CRL crl = new CRL(locator);
        crl.load();
        return crl;
    }

    public static CRL createNew(ILocator locator) {
        CRL crl = new CRL(locator);
        return crl;
    }

    protected CRL(ILocator locator) {
        this.locator = locator;
    }

    protected void basicUpdate() throws IOException {
        byte[] newCrlBytes = null;
        IX509CRL newCrl = null;
        Throwable ex = null;
        for (IRemoteAccessInfo accessInfo : this.getAccessInfos()) {
            IRemoteAccessor accessor = RemoteAccessorRegistry.get().lookupAccessor(accessInfo);
            try {
                newCrlBytes = accessor.download(accessInfo);
                if (newCrlBytes == null) break;
                ByteArrayInputStream is = new ByteArrayInputStream(newCrlBytes);
                newCrl = X509CertificateFactory.get().createCRL(is);
                break;
            }
            catch (Exception e) {
                Log.debug(e.getMessage(), (Throwable)e);
                newCrlBytes = null;
                newCrl = null;
                ex = e;
            }
        }
        if (newCrl == null) {
            if (ex == null) {
                return;
            }
            IOException ioe = new IOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
        this.basicUpdate(newCrl, newCrlBytes);
    }

    protected void basicUpdate(IX509CRL newCrl, byte[] newCrlBytes) throws IOException {
        this.deleteCRLFiles();
        File crlFile = new File(this.myDir(), FileTools.trimPath((String)this.getName()) + ".crl");
        FileTools.mkdirs((File)this.myDir());
        FileTools.write((File)crlFile, (byte[])newCrlBytes);
        this.setCRL(newCrl, this.getCRLLocator());
        this.deleteIssuerFiles();
        this.issuers = null;
        try {
            this.createIssuerFiles();
        }
        catch (CRLException e) {
            Log.debug(e.getMessage(), (Throwable)e);
            IOException ioe = new IOException();
            ioe.initCause(ioe);
            throw ioe;
        }
    }

    protected File createFile(X500Principal principal, String extension) {
        String baseName = X500NameTools.getComponentString(principal, BCStyle.CN);
        if (baseName == null) {
            baseName = principal.toString();
        }
        int i = 1;
        File file = new File(this.myDir(), baseName + "." + extension);
        while (file.exists()) {
            file = new File(this.myDir(), baseName + "(" + i + ")." + extension);
            ++i;
        }
        return file;
    }

    protected void createIssuerFiles() throws IOException, CRLException {
        Log.debug(CRL.class.getName(), (Object)"enter createIssuerFiles");
        IX509CRL crl = this.getX509CRL();
        if (crl == null) {
            Log.debug("Exit: " + CRL.class.getName(), (Object)"createIssuerFiles");
            return;
        }
        Set<X500Principal> issuers = CrlTools.getCertificateIssuers(crl);
        for (X500Principal issuer : issuers) {
            byte[] bytes = issuer.getEncoded();
            String value = X500NameTools.getComponentString(issuer, BCStyle.CN);
            if (value == null) {
                value = issuer.toString();
            }
            value = FileTools.trimPath((String)value);
            File issuerFile = new File(this.myDir(), value + ".principal");
            FileTools.write((File)issuerFile, (byte[])bytes);
        }
        Log.debug(CRL.class.getName(), (Object)"exit createIssuerFiles");
    }

    protected void deleteCRLFiles() {
        File dir = this.myDir();
        if (!dir.exists()) {
            return;
        }
        File[] crlFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".crl");
            }
        });
        if (crlFiles == null || crlFiles.length == 0) {
            return;
        }
        for (int i = 0; i < crlFiles.length; ++i) {
            File crlFile = crlFiles[i];
            crlFile.delete();
        }
    }

    protected void deleteIssuerFiles() {
        Log.debug("Enter: " + CRL.class.getName(), (Object)"deleteIssuerFiles");
        File dir = this.myDir();
        if (!dir.exists()) {
            Log.debug("Exit: " + CRL.class.getName(), (Object)"deleteIssuerFiles");
            return;
        }
        File[] issuerFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".principal");
            }
        });
        if (issuerFiles == null || issuerFiles.length == 0) {
            Log.debug("Exit: " + CRL.class.getName(), (Object)"deleteIssuerFiles");
            return;
        }
        for (int i = 0; i < issuerFiles.length; ++i) {
            File issuerFile = issuerFiles[i];
            issuerFile.delete();
        }
        Log.debug("Exit: " + CRL.class.getName(), (Object)"deleteIssuerFiles");
    }

    @Override
    public List<IRemoteAccessInfo> getAccessInfos() {
        return this.accessInfos;
    }

    protected ILocator getConfigFile() {
        return this.getLocator().getChild(NAME_CONFIG_FILE);
    }

    protected ILocator getCRLLocator() throws IOException {
        ILocator dir = this.getLocator();
        if (!this.getLocator().isDirectory()) {
            return null;
        }
        ILocator[] crlFiles = dir.listLocators(new ILocatorNameFilter(){

            public boolean accept(ILocator parent, String name) {
                return name.endsWith(".crl");
            }
        });
        if (crlFiles == null || crlFiles.length == 0) {
            return null;
        }
        return crlFiles[0];
    }

    @Override
    public X500Principal[] getIssuers() {
        this.handleSynch();
        if (this.issuers == null) {
            this.issuers = this.loadIssuers();
        }
        return this.issuers;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.locator.getName();
        }
        return this.name;
    }

    @Override
    public IX509CRL getX509CRL() throws IOException, CRLException {
        this.handleSynch();
        IX509CRL result = null;
        if (this.crlImpl != null) {
            result = this.crlImpl.get();
        }
        if (result == null) {
            result = this.loadX509CRL();
            this.setCRL(result, this.getCRLLocator());
        }
        return result;
    }

    protected void handleSynch() {
        Log.debug("Enter: " + CRL.class.getName(), (Object)"handleSynch");
        Log.debug("synching crl '" + this.getName() + "'");
        if (!this.isOutOfSynch()) {
            Log.debug("crl file not out of synch");
            Log.debug("Exit: " + CRL.class.getName(), (Object)"handleSynch");
            return;
        }
        Log.debug("crl file out of synch, reload");
        try {
            IX509CRL crl = this.loadX509CRL();
            this.setCRL(crl, this.getCRLLocator());
            this.deleteIssuerFiles();
            this.issuers = null;
            this.createIssuerFiles();
        }
        catch (IOException e) {
            Log.warn("Errory synchronizing file system CRL.", (Object)e.getMessage());
        }
        catch (CRLException e) {
            Log.warn("Errory synchronizing file system CRL.", (Object)e.getMessage());
        }
        Log.debug("Exit: " + CRL.class.getName(), (Object)"handleSynch");
    }

    protected boolean isOutOfSynch() {
        if (this.crlLocator == null) {
            return false;
        }
        this.crlLocator.synch();
        return this.crlLocator.isOutOfSynch();
    }

    protected void load() throws IOException {
        ILocator configFile = this.getConfigFile();
        if (configFile.exists() && !configFile.isDirectory()) {
            IDocument doc = DocumentTools.parse((ILocator)configFile);
            IElement eRoot = doc.getRootElement();
            this.name = eRoot.attributeValue(ATTR_NAME, null);
            Iterator accessInfoElements = eRoot.elementIterator(ELEM_REMOTEACCESS);
            while (accessInfoElements.hasNext()) {
                IElement eAccessInfo = (IElement)accessInfoElements.next();
                String type = eAccessInfo.attributeValue(ATTR_TYPE, null);
                if (type == null) continue;
                IRemoteAccessInfo accessInfo = null;
                if ("HTTP".equals(type)) {
                    accessInfo = RemoteAccessInfoHTTP.parse(eAccessInfo);
                } else if ("LDAP".equals(type)) {
                    accessInfo = RemoteAccessInfoLDAP.parse(eAccessInfo);
                }
                if (accessInfo == null) continue;
                this.accessInfos.add(accessInfo);
            }
        } else if (this.getCRLLocator() == null) {
            throw new IOException("not a valid CRL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected X500Principal[] loadIssuers() {
        Log.debug("Enter: " + CRL.class.getName(), (Object)"loadIssuers");
        Log.debug("loading issuers for crl '" + this.getName() + "'");
        HashSet<X500Principal> principals = new HashSet<X500Principal>();
        try {
            if (this.getX509CRL() != null) {
                principals.add(this.getX509CRL().getIssuerX500Principal());
            }
        }
        catch (CRLException e) {
            Log.warn("Errory parsing CRL.", (Object)e.getMessage());
        }
        catch (IOException e) {
            Log.warn("Errory loading CRL.", (Object)e.getMessage());
        }
        File dir = this.myDir();
        if (dir.exists()) {
            FileFilter principalFilter;
            File[] principalFiles;
            File[] cerFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".cer");
                }
            });
            if (cerFiles != null) {
                for (int i = 0; i < cerFiles.length; ++i) {
                    File cerFile = cerFiles[i];
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(cerFile);
                        IX509Certificate cert = X509CertificateFactory.get().createCertificate(is);
                        principals.add(cert.getSubjectX500Principal());
                    }
                    catch (IOException e) {
                        Log.warn("Errory parsing CRL.", (Object)e.getMessage());
                        StreamTools.close((Closeable)is);
                        continue;
                    }
                    catch (CertificateException e2) {
                        Log.warn("Errory loading CRL.", (Object)e2.getMessage());
                        {
                            catch (Throwable throwable) {
                                StreamTools.close(is);
                                throw throwable;
                            }
                        }
                        StreamTools.close((Closeable)is);
                        continue;
                    }
                    StreamTools.close((Closeable)is);
                    continue;
                }
            }
            if ((principalFiles = dir.listFiles(principalFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".principal");
                }
            })) == null || principalFiles.length == 0) {
                try {
                    this.createIssuerFiles();
                }
                catch (CRLException e) {
                    Log.warn("Errory parsing CRL.", (Object)e.getMessage());
                }
                catch (IOException e) {
                    Log.warn("Errory loading CRL.", (Object)e.getMessage());
                }
                principalFiles = dir.listFiles(principalFilter);
            }
            if (principalFiles != null && principalFiles.length > 0) {
                for (int i = 0; i < principalFiles.length; ++i) {
                    File principalFile = principalFiles[i];
                    try {
                        byte[] principalBytes = FileTools.getBytes((File)principalFile);
                        X500Principal principal = new X500Principal(principalBytes);
                        principals.add(principal);
                        continue;
                    }
                    catch (IOException e) {
                        Log.warn("Errory loading CRL.", (Object)e.getMessage());
                    }
                }
            }
        }
        Log.debug("Exit: " + CRL.class.getName(), (Object)"loadIssuers");
        return principals.toArray(new X500Principal[principals.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IX509CRL loadX509CRL() throws IOException, CRLException {
        Log.debug("Enter: " + CRL.class.getName(), (Object)"loadX509CRL");
        ILocator crlFile = this.getCRLLocator();
        if (crlFile == null) {
            Log.debug("Exit: " + CRL.class.getName(), (Object)"loadX509CRL");
            return null;
        }
        InputStream is = null;
        try {
            is = crlFile.getInputStream();
            IX509CRL iX509CRL = X509CertificateFactory.get().createCRL(is);
            return iX509CRL;
        }
        finally {
            StreamTools.close((Closeable)is);
            Log.debug("Exit: " + CRL.class.getName(), (Object)"loadX509CRL");
        }
    }

    public File myDir() {
        return new File(this.getLocator().getPath());
    }

    @Override
    public void save() throws IOException {
        IElement eRoot = ElementFactory.get().createElement(ELEM_CRL);
        if (this.name != null) {
            eRoot.setAttributeValue(ATTR_NAME, this.name);
        }
        IDocument doc = ElementFactory.get().createDocument();
        doc.setRootElement(eRoot);
        for (IRemoteAccessInfo accessInfo : this.accessInfos) {
            String type = accessInfo.getType();
            IElement eRemoteAccess = eRoot.newElementMapped(ELEM_REMOTEACCESS);
            eRemoteAccess.setAttributeValue(ATTR_TYPE, type);
            if ("HTTP".equals(type)) {
                ((RemoteAccessInfoHTTP)accessInfo).serialize(eRemoteAccess);
                continue;
            }
            if (!"LDAP".equals(type)) continue;
            ((RemoteAccessInfoLDAP)accessInfo).serialize(eRemoteAccess);
        }
        DocumentTools.save((IDocument)doc, (ILocator)this.getConfigFile());
    }

    @Override
    public void setAccessInfos(List<IRemoteAccessInfo> accessInfos) {
        this.accessInfos = accessInfos;
    }

    protected void setCRL(IX509CRL crl, ILocator locator) {
        if (crl == null) {
            this.crlImpl = null;
            this.crlLocator = null;
        } else {
            this.crlImpl = new SoftReference<IX509CRL>(crl);
            this.crlLocator = locator;
            locator.synch();
        }
    }

    @Override
    public void setName(String name) {
        boolean changeDirectory = false;
        if (this.name == null || this.name.equals(this.getLocator().getName())) {
            changeDirectory = true;
        }
        this.name = name;
        if (changeDirectory) {
            ILocator baseLocator = this.getLocator().getParent();
            ILocator newLocator = baseLocator.getChild(FileTools.trimPath((String)name));
            File oldDir = this.myDir();
            if (oldDir.exists()) {
                File newDir = new File(newLocator.getPath());
                oldDir.renameTo(newDir);
            }
            this.locator = newLocator;
        }
    }

    @Override
    public void setX509CRL(IX509CRL crl) throws IOException, CRLException {
        this.basicUpdate(crl, crl.getEncoded());
    }

    @Override
    public IUpdateResult update() {
        UpdateResult result = new UpdateResult();
        result.setTime(DateEnvironment.get().now());
        try {
            this.basicUpdate();
            result.setSuccessful(true);
        }
        catch (IOException e) {
            result.setSuccessful(false);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }
}

